% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichr.R
\name{rba_enrichr_add_background}
\alias{rba_enrichr_add_background}
\title{Upload Background Gene-List to Enrichr}
\usage{
rba_enrichr_add_background(background_genes, ...)
}
\arguments{
\item{background_genes}{A character vector of Entrez gene symbols of the
background genes.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list with the unique IDs for your uploaded background gene list.
}
\description{
In addition to the main gene list, you can also submit a background gene
  list to Enrichr. This gene list can be used later to compute the
  statistics of the enrichment analysis.
}
\details{
Please note that \code{\link{rba_enrichr}} provides a one-step and
  more convenient way to automatically handle this and other required
  function calls needed to perform gene set enrichment analysis with Enrichr.
}
\section{Corresponding API Resources}{

 "POST https://maayanlab.cloud/speedrichr/api/addbackground"
}

\examples{
\donttest{
my_background_genes <- c(
"NSUN3", "POLRMT", "NLRX1", "SFXN5", "ZC3H12C", "SLC25A39", "ARSG",
"DEFB29", "PCMTD2", "ACAA1A", "LRRC1", "2810432D09RIK", "SEPHS2",
"SAC3D1", "TMLHE", "LOC623451", "TSR2", "PLEKHA7", "GYS2", "ARHGEF12",
"HIBCH", "LYRM2", "ZBTB44", "ENTPD5", "RAB11FIP2", "LIPT1",
"INTU", "ANXA13", "KLF12", "SAT2", "GAL3ST2", "VAMP8", "FKBPL",
"AQP11", "TRAP1", "PMPCB", "TM7SF3", "RBM39", "BRI3", "KDR", "ZFP748",
"NAP1L1", "DHRS1", "LRRC56", "WDR20A", "STXBP2", "KLF1", "UFC1",
"CCDC16", "9230114K14RIK", "RWDD3", "2610528K11RIK")

rba_enrichr_add_background(background_genes = my_background_genes)
}

}
\references{
\itemize{
  \item Chen, E.Y., Tan, C.M., Kou, Y. et al. Enrichr: interactive and
  collaborative HTML5 gene list enrichment analysis tool. Bioinformatics
  14, 128 (2013). https://doi.org/10.1186/1471-2105-14-128
  \item Maxim V. Kuleshov, Matthew R. Jones, Andrew D. Rouillard, Nicolas
  F. Fernandez, Qiaonan Duan, Zichen Wang, Simon Koplev, Sherry L. Jenkins,
  Kathleen M. Jagodnik, Alexander Lachmann, Michael G. McDermott,
  Caroline D. Monteiro, Gregory W. Gundersen, Avi Ma’ayan, Enrichr: a
  comprehensive gene set enrichment analysis web server 2016 update,
  Nucleic Acids Research, Volume 44, Issue W1, 8 July 2016, Pages W90–W97,
  https://doi.org/10.1093/nar/gkw377
  \item Xie, Z., Bailey, A., Kuleshov, M. V., Clarke, D. J. B.,
  Evangelista, J. E., Jenkins, S. L., Lachmann, A., Wojciechowicz, M. L.,
  Kropiwnicki, E., Jagodnik, K. M., Jeon, M., & Ma’ayan, A. (2021). Gene
  set knowledge discovery with Enrichr. Current Protocols, 1, e90.
  doi: 10.1002/cpz1.90
  \item \href{https://maayanlab.cloud/Enrichr/help#api}{Enrichr API
  Documentation}
  \item \href{https://maayanlab.cloud/Enrichr/help#terms}{Citations note
  on Enrichr website}
  }
}
\seealso{
\code{\link{rba_enrichr}}

Other "Enrichr": 
\code{\link{rba_enrichr}()},
\code{\link{rba_enrichr_add_list}()},
\code{\link{rba_enrichr_enrich}()},
\code{\link{rba_enrichr_gene_map}()},
\code{\link{rba_enrichr_libs}()},
\code{\link{rba_enrichr_view_list}()}
}
\concept{"Enrichr"}
