% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichr.R
\name{rba_enrichr_add_list}
\alias{rba_enrichr_add_list}
\title{Upload Your Gene-List to Enrichr}
\usage{
rba_enrichr_add_list(gene_list, description = NULL, organism = "human", ...)
}
\arguments{
\item{gene_list}{A vector with Entrez gene symbols.}

\item{description}{(optional) A name or description to be associated with your
uploaded gene-set to Enrichr servers.}

\item{organism}{(default = "human") Which model organism version of Enrichr
to use? Available options are: "human", (H. sapiens & M. musculus),
"fly" (D. melanogaster), "yeast" (S. cerevisiae), "worm" (C. elegans)
and "fish" (D. rerio).}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list with two unique IDs for your uploaded gene sets.
}
\description{
Prior to perform enrichment, Enrichr requires you to upload your gene-list
  and retrieve a 'user list ID'.
}
\details{
Note that using \code{\link{rba_enrichr}} is a more convenient way to
   automatically perform this and other required function calls to enrich
   your input gene-set.
}
\section{Corresponding API Resources}{

 "POST https://maayanlab.cloud/Enrichr/addList"
}

\examples{
\donttest{
rba_enrichr_add_list(gene_list = c("TP53", "TNF", "EGFR"),
     description = "tumoral genes")
}

}
\references{
\itemize{
  \item Chen EY, Tan CM, Kou Y, Duan Q, Wang Z, Meirelles GV, Clark NR,
  Ma'ayan A. Enrichr: interactive and collaborative HTML5 gene list
  enrichment analysis tool. BMC Bioinformatics. 2013;128(14).
  \item Kuleshov MV, Jones MR, Rouillard AD, Fernandez NF, Duan Q, Wang Z,
  Koplev S, Jenkins SL, Jagodnik KM, Lachmann A, McDermott MG, Monteiro CD,
  Gundersen GW, Ma'ayan A. Enrichr: a comprehensive gene set enrichment
  analysis web server 2016 update. Nucleic Acids Research. 2016; gkw377.
  \item \href{https://maayanlab.cloud/Enrichr/help#api}{Enrichr API
  Documentation}
  }
}
\seealso{
\code{\link{rba_enrichr}}

Other "Enrichr": 
\code{\link{rba_enrichr_enrich}()},
\code{\link{rba_enrichr_gene_map}()},
\code{\link{rba_enrichr_libs}()},
\code{\link{rba_enrichr_view_list}()},
\code{\link{rba_enrichr}()}
}
\concept{"Enrichr"}
