% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libbi.R
\name{filter}
\alias{filter}
\alias{filter.libbi}
\alias{filter}
\alias{filter.bi_model}
\alias{filter}
\alias{filter.character}
\title{Using the LibBi wrapper to filter}
\usage{
\method{filter}{libbi}(x, ...)

\method{filter}{bi_model}(x, ...)

\method{filter}{character}(x, ...)
}
\arguments{
\item{x}{a \code{\link{libbi} or \link{bi_model}} object, or the name of a file containing the model}

\item{...}{options to be passed to \code{\link{run.libbi}}}
}
\value{
a \code{\link{libbi}} object
}
\description{
The method \code{filter} launches \code{libbi} to filter state trajectories. See the options to \code{\link{run.libbi}} for how to specify the various components of sampling with LibBi, and the LibBi manual for all options that can be passed when the client is \code{filter}.

If \code{x} is given as a 'bi_model', a \code{\link{libbi}} object will be created from the model
If \code{x} is given as a character string, it will be interpreted as the filename of a model to sample from.

For the help page of the base R \code{filter} function, see \code{\link[stats]{filter}}.
}
