% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhl_getsubjectparts.R
\name{bhl_getsubjectparts}
\alias{bhl_getsubjectparts}
\title{Return a list of parts (articles, chapters, etc) associated with a subject.}
\usage{
bhl_getsubjectparts(subject = NULL, as = "table", key = NULL, ...)
}
\arguments{
\item{subject}{the full or partial subject for which to search (character)}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"),
or parsed table ("table", default). Note that \code{as="table"} can give
different data format back depending on the function - for example,
sometimes a data.frame and sometimes a character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron}
as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\description{
Note: haven't seen examples for this function that work yet...
}
\examples{
\dontrun{
bhl_getsubjectparts('frogs')
bhl_getsubjectparts('diptera', 'xml')
bhl_getsubjectparts('diptera', 'json')
}
}
