% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhl_getitempages.R
\name{bhl_getitempages}
\alias{bhl_getitempages}
\title{Return a list of an item's pages.}
\usage{
bhl_getitempages(itemid, ocr = FALSE, as = "table", key = NULL, ...)
}
\arguments{
\item{itemid}{the item id (character)}

\item{ocr}{return ocr text of the page (TRUE/FALSE)}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"), or parsed table
("table", default). Note that \code{as="table"} can give different data format back
depending on the function - for example, sometimes a data.frame and sometimes a
character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron} as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Return a list of an item's pages.
}
\examples{
\dontrun{
bhl_getitempages('16800')
bhl_getitempages('16800', as='json')
bhl_getitempages('16800', as='xml')

# Return ocr text
bhl_getitempages('16800', TRUE)
}
}

