% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bhl_getpartnames.R
\name{bhl_getpartnames}
\alias{bhl_getpartnames}
\title{Return a list of scientific names associated with a part.}
\usage{
bhl_getpartnames(partid, as = "table", key = NULL, ...)
}
\arguments{
\item{partid}{The identifier of an individual part (article, chapter, etc) (character)}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"), or parsed table
("table", default). Note that \code{as="table"} can give different data format back
depending on the function - for example, sometimes a data.frame and sometimes a
character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron} as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Return a list of scientific names associated with a part.
}
\examples{
\dontrun{
bhl_getpartnames(7443, "xml")
bhl_getpartnames(7443, "json")
bhl_getpartnames(7443, "list")
}
}

