% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bhl_getauthortitles.R
\name{bhl_getauthortitles}
\alias{bhl_getauthortitles}
\title{Return a list of titles associated with a given BHL author identifier.}
\usage{
bhl_getauthortitles(creatorid, as = "table", key = NULL, ...)
}
\arguments{
\item{creatorid}{BHL identifier for a particular author (numeric)}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"), or parsed table
("table", default). Note that \code{as="table"} can give different data format back
depending on the function - for example, sometimes a data.frame and sometimes a
character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron} as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Unless the identifier  for a particular BHL author record is known in
   advance, this method should be used in combination	with the AuthorSearch
   method.
}
\examples{
\dontrun{
bhl_getauthortitles(1970)
bhl_getauthortitles(1970, as='json')
bhl_getauthortitles(1970, as='xml')
bhl_getauthortitles(1970, as='list')
}
}

