% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spatial.r
\name{nodeSpatial}
\alias{nodeSpatial}
\alias{pointSpatial}
\title{Vertices as Spatial points.}
\usage{
nodeSpatial(bgm)

pointSpatial(bgm)
}
\arguments{
\item{bgm}{BGM object from \code{\link{bgmfile}}}
}
\value{
\code{\link[sp]{SpatialPointsDataFrame}}
}
\description{
Obtain all vertices as a \code{\link[sp]{SpatialPointsDataFrame}}.
}
\details{
Nodes are the unique coordinates (or vertices), points are the instances of those coordinates that exist in the model. 
\code{\link{pointSpatial}} returns all instances of the vertices with information about which boxes they belong to. 
\code{\link{nodeSpatial}} returns all vertices.
}
\examples{
fname <- bgmfiles::bgmfiles(pattern = "antarctica_28")
bgm <- bgmfile(fname)
spnode <- nodeSpatial(bgm)
names(spnode)
nrow(spnode)  ## only unique vertices
nrow(bgm$vertices)

sppoints <- pointSpatial(bgm)
names(sppoints)
nrow(sppoints)
}

