% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC.R
\name{thinner}
\alias{thinner}
\title{Thin iterations.}
\usage{
thinner(proportion = 0.1, set = get("info"))
}
\arguments{
\item{proportion}{Proportion of iterations to remove. Should be between 0 and 1. Default \code{proportion=0.1}.}

\item{set}{Detailed information of the current run, stored within this session's memory as variable \code{info}.}
}
\value{
NA
}
\description{
Randomly thin iterations by a given proportion, for example if autocorrelation is visible within the MCMC series.
}
\details{
From all iterations, a proportion is removed with to-be-removed iterations sampled randomly among all iterations.
}
\examples{
\dontshow{
  Bacon(run=FALSE, coredir=tempfile())
  thinner(.1)
  agedepth(d.res=50, age.res=50, d.by=10)
}
\dontrun{
  Bacon(ask=FALSE, coredir=tempfile())
  thinner(.2)
  agedepth()
}

}
\author{
Maarten Blaauw, J. Andres Christen
}
