% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write.R
\name{bacon2clam}
\alias{bacon2clam}
\title{Translate Bacon .csv files to clam .csv files.}
\usage{
bacon2clam(core, bacondir = "Bacon_runs", clamdir = "clam_runs", sep = ",")
}
\arguments{
\item{core}{The name of the core for which a Bacon .csv.file needs to be translated into a clam .csv file}

\item{bacondir}{The directory where the Bacon runs reside. Defaults to \code{coredir="Bacon_runs"}.}

\item{clamdir}{The directory where the clam runs reside. Defaults to \code{coredir="clam_runs"}.}

\item{sep}{The separator for the .csv files. Defaults to \code{sep=","}.}
}
\value{
A clam .csv file
}
\description{
Reads a Bacon .csv file containing the dates, and transforms it into a clam .csv file.
}
\details{
Assumes that Bacon .csv files with 4 columns indicate 14C dates. Please make sure this is correct.
}
\examples{
{
\donttest{
 tmpfl <- tempfile()
  Bacon(run=FALSE, ask=FALSE, coredir=tmpfl)
  bacon2clam("MSB2K", bacondir=tmpfl, clamdir=tmpfl)
 }
}
}
\seealso{
\url{http://www.qub.ac.uk/chrono/blaauw/manualBacon_2.3.pdf}
}
\author{
Maarten Blaauw, J. Andres Christen
}
