% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bacon.R
\name{proxy.ghost}
\alias{proxy.ghost}
\title{Proxies analysed along the depths of a core can be plotted as 'proxy-ghost' graphs against calendar time while taking into account chronological uncertainties. Here darker grey indicates more likely calendar ages for specific proxy values.}
\usage{
proxy.ghost(proxy = 1, proxy.lab = c(), proxy.res = 200, yr.res = 200,
  grey.res = 100, set = get("info"), bins = c(), dark = 1,
  darkest = 1, rotate.axes = FALSE, proxy.rev = FALSE, yr.rev = FALSE,
  plot.mn = FALSE, mn.col = "red", yr.lim = c(), proxy.lim = c(),
  sep = ",", xaxs = "i", yaxs = "i", xaxt = "s", yaxt = "s",
  bty = "l", BCAD = set$BCAD, yr.lab = ifelse(BCAD, "BC/AD", "cal yr BP"),
  cleanup = TRUE)
}
\arguments{
\item{proxy}{Which proxy to use (counting from the column number in the .csv file after the depths column).}

\item{proxy.lab}{Label of the proxy axis. Default names are taken from the csv file.}

\item{proxy.res}{Greyscale pixels are calculated for \code{proxy.res=200} proxy values by default.}

\item{yr.res}{Resolution or amount of greyscale pixels to cover the age scale of the age-model plot. Default \code{yr.res=200}.}

\item{grey.res}{Grey-scale resolution of the proxy graph. Default \code{grey.res=100}. See also \code{bins}.}

\item{set}{Detailed information of the current run, stored within this session's memory as variable info.}

\item{bins}{Bin sizes to calculate the grey-scales are calculated automatically. See also \code{grey.res}.}

\item{dark}{By default, the darkest grey value is assigned to the most likely value within the entire core (normalised to 1; \code{dark=1}). By setting dark to, e.g., \code{dark=.8}, all values of and above 0.8 will be darkest (and values below that threshold will be lighter grey the lower their probabilities).}

\item{darkest}{Darkness of the most likely value. Is black by default (\code{darkest=1}); lower values will result in lighter grey.}

\item{rotate.axes}{The default is to plot the calendar horizontally, however the plot can be rotated (\code{rotate.axes=TRUE}).}

\item{proxy.rev}{The proxy axis can be reversed if \code{proxy.rev=TRUE}.}

\item{yr.rev}{The calendar axis can be reversed using \code{yr.rev=TRUE}.}

\item{plot.mn}{The mean ages of the proxy values can be added using \code{plot.mn=TRUE}.}

\item{mn.col}{Colour of the weighted mean ages of the proxy values.}

\item{yr.lim}{Minimum and maximum calendar age ranges, calculated automatically by default (\code{yr.lim=c()}).}

\item{proxy.lim}{Ranges of the proxy axis, calculated automatically by default (\code{proxy.lim=c()}).}

\item{sep}{Separator between the fields of the plain text file containing the depth and proxy data.}

\item{xaxs}{Extension of x-axis. By default, no white-space will be added at the axis extremes (\code{xaxs="i"}). See ?par for other options.}

\item{yaxs}{Extension of y-axis. By default, no white-space will be added at the axis extremes (\code{xaxs="i"}). See ?par for other options.}

\item{xaxt}{The x-axis is plotted by default, but this can be switched off using \code{xaxt="n"}.}

\item{yaxt}{The y-axis is plotted by default, but this can be switched off using \code{yaxt="n"}.}

\item{bty}{Type of box to be drawn around the plot (\code{"n"} for none, and \code{"l"} (default), \code{"7"}, \code{"c"}, \code{"u"}, or \code{"o"} for correspondingly shaped boxes).}

\item{BCAD}{The calendar scale of graphs and age output-files is in \code{cal BP} by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}

\item{yr.lab}{The labels for the calendar axis (default \code{yr.lab="cal BP"} or \code{"BC/AD"} if \code{BCAD=TRUE}).}

\item{cleanup}{Temporary files to produce the greyscales are removed automatically after the plot has been produced (\code{cleanup=TRUE}).}
}
\value{
A grey-scale graph of the proxy against calendar age.
}
\description{
Proxies analysed along the depths of a core can be plotted as 'proxy-ghost' graphs against calendar time while taking into account chronological uncertainties. Here darker grey indicates more likely calendar ages for specific proxy value.
}
\details{
Place a csv file with the values of proxies against depth within your core's folder. The values should be in columns separated by commas (default \code{sep=","}), the first column containing the depths and the first line (header) containing the proxy names. 
The file name should start with the core's name and end with "_proxies.csv". For an example see \code{"Bacon_coredir/MSB2K/MSB2K_proxies.csv"} or \code{"Cores/MSB2K/MSB2K_proxies.csv"}.
}
\examples{
\donttest{
Bacon(ask=FALSE)
layout(1)
proxy.ghost()
}
}
\references{
Blaauw, M. and Christen, J.A., Flexible paleoclimate age-depth models using an autoregressive 
gamma process. Bayesian Anal. 6 (2011), no. 3, 457--474. 
\url{https://projecteuclid.org/download/pdf_1/euclid.ba/1339616472}
}
\seealso{
\url{http://www.chrono.qub.ac.uk/blaauw/manualBacon_2.3.pdf}
}
\author{
Maarten Blaauw, J. Andres Christen
}
