% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bacon.R
\name{Bacon.hist}
\alias{Bacon.hist}
\title{Calculate age distributions of depths.}
\usage{
Bacon.hist(d, set = get("info"), bins = c(), tmpfile = "tempfile1",
  depthfile = "tempfile2", yr.lab = c(), yr.lim = c(),
  hist.lab = "Frequency", hist.lim = c(), Plot = TRUE, yr.res = 200,
  prob = set$prob, hist.col = grey(0.5), hist.border = grey(0.2),
  range.col = "blue", med.col = "green", mn.col = "red", cleanup = TRUE)
}
\arguments{
\item{d}{The depth or depths for which a histogram and age ranges should be provided. If multiple depths are given, then just the age ranges, median and means (no graphs) are provided for each depth.}

\item{set}{Detailed information of the current run, stored within this session's memory as variable info.}

\item{bins}{Bacon will try to automatically estimate reasonable bin sizes. Changing the histograms bin size could alter the shape of the histogram considerably. Values below c. 50 are generally not recommended.}

\item{tmpfile}{Name and location of a temporary file. By default uses the location suggested by R's function \link{tempfile}.}

\item{depthfile}{Name and location of a temporary file. By default uses the location suggested by R's function \link{tempfile}.}

\item{yr.lab}{The labels for the calendar axis (default \code{yr.lab="cal BP"} or \code{"BC/AD"} if \code{BCAD=TRUE}).}

\item{yr.lim}{Minimum and maximum calendar age ranges, calculated automatically by default (\code{yr.lim=c()}).}

\item{hist.lab}{The y-axis is labelled \code{ylab="Frequency"} by default.}

\item{hist.lim}{Limits of the y-axis.}

\item{Plot}{Make a plot or not. Defaults to \code{Plot=TRUE}, however no plots are made if more than one depth \code{d} is provided.
If \code{Plot=FALSE}, then the age ranges, median and mean are given for each depth (as four columns).}

\item{yr.res}{Bacon will try to automatically estimate reasonable bin sizes. Changing the histograms bin size could alter the shape of the histogram considerably. Values below c. 50 are generally not recommended. See also \code{bins}.}

\item{prob}{Age ranges are given as quantiles, e.g., 2.5\% and 97.5\% for the default of 95\% confidence limits (\code{prob=0.95})).}

\item{hist.col}{Colour of the histogram. Default grey, \code{hist.col=grey(0.5)}.}

\item{hist.border}{Colour of the histogram's outline. Default dark grey, \code{hist.border=grey(0.2)}.}

\item{range.col}{Colour of confidence ranges. Defaults to \code{range.col="blue"}.}

\item{med.col}{Colour of the weighted mean. Defaults to \code{med.col="green"}.}

\item{mn.col}{Colour of the mean. Defaults to \code{mn.col="red"}.}

\item{cleanup}{The drawing of the plot uses temporary files, which are removed afterward by default (\code{cleanup=TRUE}).}
}
\value{
A plot with the histogram and the age ranges, median and mean, or just the age ranges, medians and means if more than one depth \code{d} is given.
}
\description{
Calculate the distribution of age estimates of single or multiple depths.
}
\details{
Age estimates of specific depths can also be plotted.
}
\examples{
  Bacon(run=FALSE)
  agedepth(yr.res=50)
  Bacon.hist(20) 
  Bacon.hist(20:30) 
}
\references{
Blaauw, M. and Christen, J.A., Flexible paleoclimate age-depth models using an autoregressive 
gamma process. Bayesian Anal. 6 (2011), no. 3, 457--474. 
\url{https://projecteuclid.org/download/pdf_1/euclid.ba/1339616472}
}
\seealso{
\url{http://www.chrono.qub.ac.uk/blaauw/manualBacon_2.3.pdf}
}
\author{
Maarten Blaauw, J. Andres Christen
}
