% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{ply_mesh}
\alias{ply_mesh}
\title{PLY Mesh 3D Model}
\usage{
ply_mesh(
  filename,
  center = FALSE,
  position = c(0, 0, 0),
  scale = c(1, 1, 1),
  angle = c(0, 0, 0),
  pivot_point = c(0, 0, 0),
  order_rotation = c(1, 2, 3),
  material = material_list()
)
}
\arguments{
\item{filename}{PLY filename.}

\item{center}{Default `FALSE`. Whether to center the mesh.}

\item{position}{Default `c(0,0,0)`. Position of the mesh.}

\item{scale}{Default `c(1,1,1)`. Scale of the mesh. Can also be a single numeric value scaling all axes uniformly.}

\item{angle}{Default `c(0,0,0)`. Angle to rotate the mesh.}

\item{pivot_point}{Default `c(0,0,0)`. Point around which to rotate the mesh.}

\item{order_rotation}{Default `c(1,2,3)`. Order to rotate the axes.}

\item{material}{Default `material_list()` (default values). Specify the material of the object.}
}
\value{
List describing the mesh.
}
\description{
PLY Mesh 3D Model
}
\examples{
#See the documentation for `obj_mesh()`--no example PLY models are included with this package,
#but the process of loading a model is the same (but no materials are included in PLY files).
}
