% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{cylinder_mesh}
\alias{cylinder_mesh}
\title{Cylinder 3D Model}
\usage{
cylinder_mesh(
  position = c(0, 0, 0),
  radius = 0.5,
  length = 1,
  angle = c(0, 0, 0),
  pivot_point = c(0, 0, 0),
  order_rotation = c(1, 2, 3),
  material = material_list()
)
}
\arguments{
\item{position}{Default \code{c(0,0,0)}. Position of the mesh.}

\item{radius}{Default \code{0.5}. Radius of the cylinder.}

\item{length}{Default \code{1}. Length of the cylinder.}

\item{angle}{Default \code{c(0,0,0)}. Angle to rotate the mesh.}

\item{pivot_point}{Default \code{c(0,0,0)}. Point around which to rotate the mesh.}

\item{order_rotation}{Default \code{c(1,2,3)}. Order to rotate the axes.}

\item{material}{Default \code{material_list()} (default values). Specify the material of the object.}
}
\value{
List describing the mesh.
}
\description{
Cylinder 3D Model
}
\examples{
if(run_documentation()) {
#Generate a cylinder
generate_cornell_mesh() |>
  add_shape(cylinder_mesh(position=c(555/2,150,555/2),
                          radius = 50, length=300, material = material_list(diffuse="purple"))) |>
  rasterize_scene(light_info = directional_light(c(0.5,0.5,-1)))
}
if(run_documentation()) {
#Generate a wide, thin disk
generate_cornell_mesh() |>
  add_shape(cylinder_mesh(position=c(555/2,20,555/2),
                          radius = 200, length=5, material = material_list(diffuse="purple"))) |>
  rasterize_scene(light_info = directional_light(c(0.5,0.5,-1)))
}
if(run_documentation()) {
#Generate a narrow cylinder
generate_cornell_mesh() |>
  add_shape(cylinder_mesh(position=c(555/2,555/2,555/2),angle=c(45,-45,0),
                          radius = 10, length=500, material = material_list(diffuse="purple"))) |>
  rasterize_scene(light_info = directional_light(c(0.5,0.5,-1)))
}
}
