% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_overlay.R
\name{add_overlay}
\alias{add_overlay}
\title{Add Overlay}
\usage{
add_overlay(
  hillshade,
  overlay,
  alphacolor = NULL,
  alphamethod = "max",
  alphalayer = 1,
  rescale_original = FALSE
)
}
\arguments{
\item{hillshade}{A three-dimensional RGB array or 2D matrix of shadow intensities.}

\item{overlay}{A three or four dimensional RGB array, where the 4th dimension represents the alpha (transparency) channel. 
If the array is 3D, `alphacolor` should also be passed to indicate transparent regions.}

\item{alphacolor}{Default `NULL`. If `overlay` is a 3-layer array, this argument tells which color is interpretted as completely transparent.}

\item{alphamethod}{Default `max`. Method for dealing with pre-existing transparency with `layeralpha`. 
If `max`, converts all alpha levels higher than `layeralpha` to the value set in `layeralpha`. Otherwise,
this just sets all transparency to `layeralpha`.}

\item{alphalayer}{Default `1`. Defines minimum tranparaency of layer. If transparency already exists in `overlay`, the way `add_overlay` combines 
the two is determined in argument `alphamethod`.}

\item{rescale_original}{Default `FALSE`. If `TRUE`, `hillshade` will be scaled to match the dimensions of `overlay` (instead of
the other way around).}
}
\value{
Hillshade with overlay.
}
\description{
Overlays an image (with a transparency layer) on the current map.
}
\examples{
#Only run these examples if the `magick` package is installed.
if ("magick" \%in\% rownames(utils::installed.packages())) {
#Combining base R plotting with rayshader's spherical color mapping and raytracing:
\donttest{
montereybay \%>\%
  sphere_shade() \%>\%
  add_overlay(height_shade(montereybay),alphalayer = 0.6)  \%>\%
  add_shadow(ray_shade(montereybay,zscale=50)) \%>\%
  plot_map()
}

\donttest{
#Add contours with `generate_contour_overlay()`
montereybay \%>\%
  height_shade() \%>\%
  add_overlay(generate_contour_overlay(montereybay))  \%>\%
  add_shadow(ray_shade(montereybay,zscale=50)) \%>\%
  plot_map()
}
}
}
