% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csg_construct.R
\name{csg_sphere}
\alias{csg_sphere}
\title{CSG Sphere}
\usage{
csg_sphere(x = 0, y = 0, z = 0, radius = 1)
}
\arguments{
\item{x}{Default `0`. x-coordinate of the center of the sphere.}

\item{y}{Default `0`. y-coordinate of the center of the sphere.}

\item{z}{Default `0`. z-coordinate of the center of the sphere.}

\item{radius}{Default `1`. Radius of the sphere.}
}
\value{
List describing the sphere in the scene.
}
\description{
CSG Sphere
}
\examples{
if(rayrender:::run_documentation()) {
#Generate a simple sphere:
generate_ground() \%>\% 
  add_object(csg_object(csg_sphere(),
                        material=glossy(color="purple"))) \%>\% 
  render_scene(clamp_value=10)
}
if(rayrender:::run_documentation()) {
#Generate a bigger sphere in the cornell box.
generate_cornell() \%>\% 
  add_object(csg_object(csg_sphere(x=555/2,y=555/2,z=555/2,radius=100),
                        material=glossy(checkercolor="purple", checkerperiod=100))) \%>\% 
  render_scene(clamp_value=10)
}
if(rayrender:::run_documentation()) {
#Combine two spheres of different sizes
generate_cornell() \%>\% 
  add_object(csg_object(
    csg_combine(
      csg_sphere(x=555/2,y=555/2-50,z=555/2,radius=100),
      csg_sphere(x=555/2,y=555/2+50,z=555/2,radius=80)),
    material=glossy(color="purple"))) \%>\% 
  render_scene(clamp_value=10)
}
if(rayrender:::run_documentation()) {
#Subtract two spheres to create an indented region
generate_cornell() \%>\% 
  add_object(csg_object(
    csg_combine(
      csg_sphere(x=555/2,y=555/2-50,z=555/2,radius=100),
      csg_sphere(x=555/2+30,y=555/2+20,z=555/2-90,radius=40),
      operation="subtract"),
    material=glossy(color="grey20"))) \%>\% 
  render_scene(clamp_value=10)
}
if(rayrender:::run_documentation()) {
#Use csg_combine(operation="blend") to melt the two together
generate_cornell() \%>\% 
  add_object(csg_object(
    csg_combine(
      csg_sphere(x=555/2,y=555/2-50,z=555/2,radius=100),
      csg_sphere(x=555/2,y=555/2+50,z=555/2,radius=80),
      operation="blend", radius=20),
    material=glossy(color="purple"))) \%>\% 
  render_scene(clamp_value=10)
}
}
