% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa.R
\name{with_future_parallel}
\alias{with_future_parallel}
\title{Enable parallel computing provided by 'future' package within the context}
\usage{
with_future_parallel(
  expr,
  env = parent.frame(),
  quoted = FALSE,
  on_failure = "multisession",
  max_workers = NA,
  ...
)
}
\arguments{
\item{expr}{the expression to be evaluated}

\item{env}{environment of the \code{expr}}

\item{quoted}{whether \code{expr} has been quoted; default is false}

\item{on_failure}{alternative 'future' plan to use if forking a process
is disallowed; this usually occurs on 'Windows' machines; see details.}

\item{max_workers}{maximum of workers; default is automatically set by
\code{raveio_getopt("max_worker",1L)}}

\item{...}{additional parameters passing into
\code{\link[dipsaus]{make_forked_clusters}}}
}
\value{
The evaluation results of \code{expr}
}
\description{
Enable parallel computing provided by 'future' package within the context
}
\details{
Some 'RAVE' functions such as \code{\link{prepare_subject_power}}
support parallel computing to speed up. However, the parallel computing is
optional. You can enable it by wrapping the function calls within
\code{with_future_parallel} (see examples).

The default plan is to use 'forked' R sessions. This is a convenient, fast,
and relative simple way to create multiple R processes that share the same
memories. However, on some machines such as 'Windows' the support has not
yet been implemented. In such cases, the plan fall backs to a back-up
specified by \code{on_failure}. By default, \code{on_failure} is
\code{'multisession'}, a heavier implementation than forking the process, and
slightly longer ramp-up time.
However, the difference should be marginal for most of the functions.

When parallel computing is enabled, the number of parallel workers is
specified by the option \code{raveio_getopt("max_worker", 1L)}.
}
\examples{

library(raveio)

demo_subject <- as_rave_subject("demo/DemoSubject", strict = FALSE)

if(dir.exists(demo_subject$path)) {
  with_future_parallel({
    prepare_subject_power("demo/DemoSubject")
  })
}

}
