% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa.R
\name{lapply_async}
\alias{lapply_async}
\title{Run \code{\link{lapply}} in parallel}
\usage{
lapply_async(
  x,
  FUN,
  FUN.args = list(),
  callback = NULL,
  ncores = NULL,
  on_failure = "multisession",
  ...
)
}
\arguments{
\item{x}{iterative elements}

\item{FUN}{function to apply to each element of \code{x}}

\item{FUN.args}{named list that will be passed to \code{FUN} as arguments}

\item{callback}{callback function or \code{NULL}. When passed as function,
the function takes one argument (elements of \code{x}) as input, and it
suppose to return one string character.}

\item{ncores}{number of cores to use, constraint by the \code{max_worker}
option (see \code{\link{raveio_getopt}}); default is the maximum number
of workers available}

\item{on_failure}{alternative strategy if fork process is
disallowed (set by users or on 'Windows')}

\item{...}{passed to \code{\link[dipsaus]{lapply_async2}}}
}
\description{
Uses \code{\link[dipsaus]{lapply_async2}}, but allows better parallel
scheduling via \code{\link{with_future_parallel}}. On 'Unix', the function
will fork processes. On 'Windows', the function uses strategies specified
by \code{on_failure}
}
\examples{


if(!is_on_cran()) {
library(raveio)

# ---- Basic example ----------------------------
lapply_async(1:16, function(x) {
  # function that takes long to fun
  Sys.sleep(1)
  x
})

# With callback
lapply_async(1:16, function(x){
  Sys.sleep(1)
  x + 1
}, callback = function(x) {
  sprintf("Calculating|\%s", x)
})

# With ncores
pids <- lapply_async(1:16, function(x){
  Sys.sleep(0.5)
  Sys.getpid()
}, ncores = 2)

# Unique number of PIDs (cores)
unique(unlist(pids))

# ---- With scheduler ----------------------------
# Scheduler pre-initialize parallel workers and temporary
# switches parallel context. The workers ramp-up
# time can be saved by reusing the workers.
#
with_future_parallel({

  # lapply_async block 1
  pids <- lapply_async(1:16, function(x){
    Sys.sleep(1)
    Sys.getpid()
  }, callback = function(x) {
    sprintf("lapply_async without ncores|\%s", x)
  })
  print(unique(unlist(pids)))

  # lapply_async block 2
  pids <- lapply_async(1:16, function(x){
    Sys.sleep(1)
    Sys.getpid()
  }, callback = function(x) {
    sprintf("lapply_async with ncores|\%s", x)
  }, ncores = 4)
  print(unique(unlist(pids)))

})


}


}
