% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-docs.R, R/pipeline-install.R,
%   R/pipeline-tools.R
\name{rave-pipeline}
\alias{rave-pipeline}
\alias{pipeline_root}
\alias{pipeline_list}
\alias{pipeline_find}
\alias{pipeline_attach}
\alias{load_targets}
\alias{pipeline_debug}
\alias{pipeline_visualize}
\alias{pipeline_run}
\alias{pipeline_progress}
\alias{pipeline_fork}
\alias{pipeline_build}
\alias{pipeline_read}
\alias{pipeline_vartable}
\alias{pipeline_hasname}
\alias{pipeline_watch}
\alias{pipeline_create_template}
\alias{pipeline_create_subject_pipeline}
\alias{pipeline_description}
\title{'RAVE' pipeline functions}
\usage{
pipeline_root(root_path)

pipeline_list(root_path = pipeline_root())

pipeline_find(name, root_path = pipeline_root())

pipeline_attach(name, root_path = pipeline_root())

load_targets(...)

pipeline_debug(
  quick = TRUE,
  env = parent.frame(),
  pipe_dir = Sys.getenv("RAVE_PIPELINE", "."),
  skip_names
)

pipeline_visualize(pipe_dir = Sys.getenv("RAVE_PIPELINE", "."))

pipeline_run(
  pipe_dir = Sys.getenv("RAVE_PIPELINE", "."),
  type = c("basic", "async", "vanilla", "custom"),
  envir = parent.frame(),
  callr_function = NULL,
  ...
)

pipeline_progress(
  pipe_dir = Sys.getenv("RAVE_PIPELINE", "."),
  method = c("summary", "details", "custom"),
  func = targets::tar_progress_summary
)

pipeline_fork(
  src = Sys.getenv("RAVE_PIPELINE", "."),
  dest = tempfile(pattern = "rave_pipeline_"),
  filter_pattern = "\\\\.(R|yaml|txt|csv|fst|conf)$",
  activate = FALSE
)

pipeline_build(pipe_dir = Sys.getenv("RAVE_PIPELINE", "."))

pipeline_read(
  var_names,
  pipe_dir = Sys.getenv("RAVE_PIPELINE", "."),
  branches = NULL,
  ifnotfound = NULL
)

pipeline_vartable(
  pipe_dir = Sys.getenv("RAVE_PIPELINE", "."),
  targets_only = TRUE,
  complete_only = FALSE,
  ...
)

pipeline_hasname(var_names, pipe_dir = Sys.getenv("RAVE_PIPELINE", "."))

pipeline_watch(
  pipe_dir = Sys.getenv("RAVE_PIPELINE", "."),
  targets_only = TRUE,
  ...
)

pipeline_create_template(
  root_path,
  pipeline_name,
  overwrite = FALSE,
  activate = TRUE,
  template_type = c("rmd", "r")
)

pipeline_create_subject_pipeline(
  subject,
  pipeline_name,
  overwrite = FALSE,
  activate = TRUE,
  template_type = c("rmd", "r")
)

pipeline_description(file)
}
\arguments{
\item{root_path}{the root directory for pipeline templates}

\item{name, pipeline_name}{the pipeline name to create; usually also the folder
name within subject's pipeline path}

\item{...}{other parameters, targets, etc.}

\item{quick}{whether to skip finished targets to save time}

\item{env, envir}{environment to execute the pipeline}

\item{pipe_dir}{where the pipeline directory is; can be set via system
environment \code{Sys.setenv("RAVE_PIPELINE"=...)}}

\item{skip_names}{hint of target names to fast skip provided they are
up-to-date; only used when \code{quick=TRUE}. If missing, then
\code{skip_names} will be automatically determined}

\item{type}{how the pipeline should be executed; current choices are
\code{"basic"} to run in the main session; \code{"async"} to run in
a separate session without blocking the main session; \code{"vanilla"} to
run in a separate session and wait for the results; or \code{"custom"} to
run customized scheduler \code{callr_function}}

\item{callr_function}{function to customized when \code{type="custom"}}

\item{method}{how the progress should be presented; choices are
\code{"summary"}, \code{"details"}, \code{"custom"}. If custom method is
chosen, then \code{func} will be called}

\item{func}{function to call when reading customized pipeline progress;
default is \code{\link[targets]{tar_progress_summary}}}

\item{src, dest}{pipeline folder to copy the pipeline script from and to}

\item{filter_pattern}{file name patterns used to filter the scripts to
avoid copying data files; default is \code{"\\.(R|yaml|txt|csv|fst|conf)$"}}

\item{activate}{whether to activate the new pipeline folder from \code{dest};
default is false}

\item{var_names}{variable name to fetch or to check}

\item{branches}{branch to read from; see \code{\link[targets]{tar_read}}}

\item{ifnotfound}{default values to return if variable is not found}

\item{targets_only}{whether to return the variable table for targets only;
default is true}

\item{complete_only}{whether only to show completed and up-to-date target
variables; default is false}

\item{overwrite}{whether to overwrite existing pipeline; default is false
so users can double-check; if true, then existing pipeline, including the
data will be erased}

\item{template_type}{which template type to create; choices are \code{'r'}
or \code{'rmd'}}

\item{subject}{character indicating valid 'RAVE' subject ID, or
\code{\link{RAVESubject}} instance}

\item{file}{path to the 'DESCRIPTION' file under the pipeline folder, or
pipeline collection folder that contains the pipeline information,
structures, dependencies, etc.}
}
\description{
Utility functions for 'RAVE' pipelines, currently designed for
internal development use. The infrastructure will be deployed to 'RAVE' in
the future to facilitate the "self-expanding" aim.
}
