% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdf5.R
\name{LazyH5}
\alias{LazyH5}
\title{Lazy 'HDF5' file loader}
\description{
provides hybrid data structure for 'HDF5' file
}
\examples{

if( dipsaus::package_installed('rhdf5') ){

# Data to save
x <- array(rnorm(1000), c(10,10,10))

# Save to local disk
f <- tempfile()
save_h5(x, file = f, name = 'x', chunk = c(10,10,10), level = 0)

# Load via LazyFST
dat <- LazyH5$new(file_path = f, data_name = 'x', read_only = TRUE)

dat

# Check whether the data is identical
range(dat - x)

# Read a slice of the data
system.time(dat[,10,])
}


}
\author{
Zhengjia Wang
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{quiet}}{whether to suppress messages}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{file_ptr_valid}}{whether file pointer is valid or broken;
internally used}

\item{\code{data_ptr_valid}}{whether data pointer is valid or broken;
internally used}

\item{\code{file_valid}}{whether file is a valid 'HDF5' file}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-finalize}{\code{LazyH5$finalize()}}
\item \href{#method-print}{\code{LazyH5$print()}}
\item \href{#method-new}{\code{LazyH5$new()}}
\item \href{#method-save}{\code{LazyH5$save()}}
\item \href{#method-open}{\code{LazyH5$open()}}
\item \href{#method-close}{\code{LazyH5$close()}}
\item \href{#method-subset}{\code{LazyH5$subset()}}
\item \href{#method-get_dims}{\code{LazyH5$get_dims()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-finalize}{}}}
\subsection{Method \code{finalize()}}{
garbage collection method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyH5$finalize()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
none
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
overrides print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyH5$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
self instance
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyH5$new(file_path, data_name, read_only = FALSE, quiet = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file_path}}{where data is stored in 'HDF5' format}

\item{\code{data_name}}{the data stored in the file}

\item{\code{read_only}}{whether to open the file in read-only mode. It's highly
recommended to set this to be true, otherwise the file connection is
exclusive.}

\item{\code{quiet}}{whether to suppress messages, default is false}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
self instance
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-save"></a>}}
\if{latex}{\out{\hypertarget{method-save}{}}}
\subsection{Method \code{save()}}{
save data to a 'HDF5' file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyH5$save(
  x,
  chunk = "auto",
  level = 7,
  replace = TRUE,
  new_file = FALSE,
  force = TRUE,
  ctype = NULL,
  size = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{vector, matrix, or array}

\item{\code{chunk}}{chunk size, length should matches with data dimension}

\item{\code{level}}{compress level, from 1 to 9}

\item{\code{replace}}{if the data exists in the file, replace the file or not}

\item{\code{new_file}}{remove the whole file if exists before writing?}

\item{\code{force}}{if you open the file in read-only mode, then saving
objects to the file will raise error. Use \code{force=TRUE} to force
write data}

\item{\code{ctype}}{data type, see \code{\link{mode}}, usually the data type
of \code{x}. Try \code{mode(x)} or \code{storage.mode(x)} for hints.}

\item{\code{size}}{deprecated, for compatibility issues}

\item{\code{...}}{passed to self \code{open()} method}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-open"></a>}}
\if{latex}{\out{\hypertarget{method-open}{}}}
\subsection{Method \code{open()}}{
open connection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyH5$open(new_dataset = FALSE, robj, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_dataset}}{only used when the internal pointer is closed, or
to write the data}

\item{\code{robj}}{data array to save}

\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-close"></a>}}
\if{latex}{\out{\hypertarget{method-close}{}}}
\subsection{Method \code{close()}}{
close connection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyH5$close(all = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{all}}{whether to close all connections associated to the data file.
If true, then all connections, including access from other programs,
will be closed}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-subset"></a>}}
\if{latex}{\out{\hypertarget{method-subset}{}}}
\subsection{Method \code{subset()}}{
subset data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyH5$subset(..., drop = FALSE, stream = FALSE, envir = parent.frame())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{drop}}{whether to apply \code{\link{drop}} the subset}

\item{\code{stream}}{whether to read partial data at a time}

\item{\code{envir}}{if \code{i,j,...} are expressions, where should the
expression be evaluated}

\item{\code{i, j, ...}}{index along each dimension}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
subset of data
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_dims"></a>}}
\if{latex}{\out{\hypertarget{method-get_dims}{}}}
\subsection{Method \code{get_dims()}}{
get data dimension
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LazyH5$get_dims(stay_open = FALSE, refresh = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{stay_open}}{whether to leave the connection opened}

\item{\code{refresh}}{whether to discard cache and read from file}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
dimension of the array
}
}
}
