% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{rasciidoc}
\alias{rasciidoc}
\title{Render an \command{asciidoc} File}
\usage{
rasciidoc(file_name, ...)
}
\arguments{
\item{file_name}{The file to run \command{asciidoc} on.}

\item{...}{arguments passed to \command{asciidoc} via \code{\link{system2}}.}
}
\value{
\code{\link[base:invisible]{Invisibly}} \command{asciidoc} return
value.
}
\description{
This is the basic interface to \command{asciidoc}. Not more than a call to
\code{\link{system2}} and checks on \command{asciidoc} and
\command{source-highlight}.
You should usually not call it directly, see
\code{\link{render}} for a wrapper.
}
\section{Warning}{

Due to the CRAN policy of not writing "anywhere else on the
file system apart from the R session's temporary directory",
we work on a temporary copy of \code{file_name}.
Thus all internal sourcing and internal links will be
broken and any output is written to \code{tempdir()}.
Set the option "write_to_disk" to TRUE (using \cr
\code{options(write_to_disk = TRUE)}\cr
to bypass this. You may want to include the above line into your ~/.Rprofile.
}

\examples{
wd <- file.path(tempdir(), "rasciidoc")
dir.create(wd)
file  <- system.file("files", "minimal", "knit.asciidoc",
                     package = "rasciidoc")
file.copy(file, wd)
rasciidoc::rasciidoc(file.path(wd, basename(file)), "-b docbook")
if (isTRUE(getOption("write_to_disk"))) {
    dir(wd, full.names = TRUE)
} else {
    dir(tempdir(), full.names = TRUE)
}
unlink(wd, recursive = TRUE)
}
