% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.species.R
\name{sim.species}
\alias{sim.species}
\alias{sim.species.SpatRaster}
\alias{sim.species.SpatialPolygons}
\alias{sim.species.sf}
\title{Simulate species distribution data for RAP}
\usage{
sim.species(x, ...)

\method{sim.species}{SpatRaster}(x, n = 1, model = "normal", ...)

\method{sim.species}{SpatialPolygons}(x, res, n = 1, model = "normal", ...)

\method{sim.species}{sf}(x, res, n = 1, model = "normal", ...)
}
\arguments{
\item{x}{\code{\link[terra:rast]{terra::rast()}} or \code{\link[sf:sf]{sf::st_sf()}} object delineating
the spatial extent for the study area.}

\item{...}{not used.}

\item{n}{\code{integer} number of species. Defaults to 1.}

\item{model}{\code{character} or \code{numeric} for simulating data.
If a \code{character} value is supplied, then the following values can
can be used to simulate species distributions with particular
characteristics:
\code{"uniform"}, \code{"normal"}, and \code{"bimodal"}.
If a \code{numeric} value is supplied, then this is used to simulate
species distributions using a Gaussian random field, where the
\code{numeric} value is treated as the scale parameter.
Defaults to \code{"normal"}.}

\item{res}{\code{numeric} resolution to simulate distributions. Only needed
when \code{\link[sf:sf]{sf::st_sf()}} are supplied.}
}
\value{
\code{\link[terra:rast]{terra::rast()}} with layers for each species.
}
\description{
This function simulates species distributions for RAP.
}
\examples{
\dontrun{
# make polygons
sim_pus <- sim.pus(225L)

# simulate 1 uniform species distribution using SpatRaster
s1 <- sim.species(blank.raster(sim_pus, 1), n = 1, model = "uniform")

# simulate 1 uniform species distribution based on sf
s2 <- sim.species(sim_pus, res = 1, n = 1, model = "uniform")

# simulate 1 normal species distributions
s3 <- sim.species(sim_pus, res = 1, n = 1, model = "normal")

# simulate 1 bimodal species distribution
s4 <- sim.species(sim_pus, res = 1, n = 1, model = "bimodal")

# simulate 1 species distribution using a random field
s5 <- sim.species(sim_pus, res = 1, n = 1, model = 0.2)

# plot simulations
par(mfrow = c(2,2))
plot(s2, main = "constant")
plot(s3, main = "normal")
plot(s4, main = "bimodal")
plot(s5, main = "random field")
}
}
