% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GurobiOpts.R
\docType{class}
\name{GurobiOpts-class}
\alias{GurobiOpts-class}
\title{GurobiOpts: An S4 class to represent Gurobi parameters}
\description{
This class is used to store Gurobi input parameters.
}
\section{Slots}{

\describe{
\item{\code{Threads}}{\code{integer} number of cores to use for processing. Defaults
to 1L.}

\item{\code{MIPGap}}{\code{numeric} MIP gap specifying minimum solution quality.
Defaults to 0.1.}

\item{\code{Method}}{\code{integer} Algorithm to use for solving model. Defaults to
0L.}

\item{\code{Presolve}}{\code{integer} code for level of computation in presolve.
Defaults to 2.}

\item{\code{TimeLimit}}{\code{integer} number of seconds to allow for solving.
Defaults to NA_integer_, and so a time limit is not imposed.}

\item{\code{NumberSolutions}}{\code{integer} number of solutions to generate.
Defaults to 1L.}

\item{\code{MultipleSolutionsMethod}}{\code{integer} name of method to obtain
multiple solutions (used when \code{NumberSolutions} is greater than one).
Available options are \code{"benders.cuts"}, \code{"solution.pool.0"},
\code{"solution.pool.1"}, and \code{"solution.pool.2"}. The
\code{"benders.cuts"} method produces a set of distinct solutions that
are all within the optimality gap. The \code{"solution.pool.0"}
method returns all solutions identified whilst trying to find
a solution that is within the specified optimality gap. The
\code{"solution.pool.1"} method finds one solution within the optimality
gap and a number of additional solutions that are of any level of quality
(such that the total number of solutions is equal to
\code{number_solutions}). The \code{"solution.pool.2"} finds a
specified number of solutions that are nearest to optimality. The
search pool methods correspond to the parameters used by the Gurobi
software suite (see \url{http://www.gurobi.com/documentation/8.0/refman/poolsearchmode.html#parameter:PoolSearchMode}).
Defaults to \code{"benders.cuts"}.}
}}

\seealso{
\code{\link[=GurobiOpts]{GurobiOpts()}}.
}
