% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_mb.R
\name{ci_mb}
\alias{ci_mb}
\title{Bootstrap Confidence Intervals for Mallows-Binomial parameters.}
\usage{
ci_mb(
  rankings,
  ratings,
  M,
  interval = 0.9,
  nsamples = 50,
  all = FALSE,
  method = "ASTAR"
)
}
\arguments{
\item{rankings}{A matrix of rankings, potentially with attribute "assignments" to signify separate
reviewer assignments. One ranking per row.}

\item{ratings}{A matrix of ratings, one row per judge and one column per object.}

\item{M}{Numeric specifying maximum (=worst quality) integer rating.}

\item{interval}{A numeric entry between 0 and 1 specifying the confidence interval (e.g.,
.90 indicates a 90\% confidence interval). Defaults to 0.90.}

\item{nsamples}{A numeric entry indicating desired number of bootstrap samples to be used when
calculating confidence intervals. Defaults to 50.}

\item{all}{A boolean indicating if estimated parameters from all bootstrap samples should be returned.
Defaults to \code{FALSE}.}

\item{method}{A character string indicating which estimation method to use when estimating parameters.
Allowable options are currently "ASTAR", "Greedy", "GreedyLocal", and "FV". Defaults to exact search, "ASTAR".}
}
\value{
A list with elements \code{ci}, a matrix of confidence intervals for Mallows-Binomial parameters,
\code{ci_ranks}, a matrix of confidence intervals for object ranks, \code{bootstrap_pi0}, a matrix of
bootstrap consensus rankings (returned only if \code{all==TRUE}), and \code{bootstrap_ptheta}, a
matrix of bootstrap estimates of (p,theta) (returned only if \code{all==TRUE}).
}
\description{
This function calculates confidence intervals for parameters in a Mallows-Binomial model
using the nonparametric bootstrap.
}
\examples{
data("ToyData1")
ci_mb(ToyData1$rankings,ToyData1$ratings,ToyData1$M,method="ASTAR",all=TRUE)

}
