% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/class.R
\docType{class}
\name{RankControlKendall-class}
\alias{RankControlKendall}
\alias{RankControlKendall-class}
\title{RankControlKendall Class}
\description{
A S4 class to store control parameters for Kendall distance model fitting (Mallow's Phi Model).
It is derived from class \code{\link{RankControl-class}}.
}
\details{
\code{RankControlKendall} is derived from virtual class \code{\link{RankControl}}.
This control class tells the solver to fit a model based on Kendall distance.
The control parameters that start with prefix \code{EM_} are intended for the EM iteration. The ones with prefix \code{SeachPi0} control the behaviour of searching model ranking.
}
\section{Slots}{

\describe{
\item{\code{EM_limit}}{maximum number of EM iteration}

\item{\code{EM_epsilon}}{convergence error for weights and cluster probabilities in EM iteration}

\item{\code{SearchPi0_limit}}{maximum number of iterations in the local search of pi0.}

\item{\code{SearchPi0_FUN}}{a function object that gives a goodness of fit criterion. The default is log likelihood.}

\item{\code{SearchPi0_fast_traversal}}{a logical value. If TRUE (by default), immediately traverse to the neighbour if it is better than the current pi0. Otherwise, check all neighbours and traverse to the best one.}

\item{\code{SearchPi0_show_message}}{a logical value. If TRUE, the location of the current pi0 is shown.}

\item{\code{SearchPi0_neighbour}}{a character string specifying which type of neighbour to use in the local search. Supported values are: "Cayley" to use neighbours in terms of Cayley distance or "Kendall" to use neighbours in terms of Kendall distance.
Note that Kendall neighbours are a subset of Cayley neighbours}

\item{\code{optimx_control}}{this slot is not used.}
}}
\examples{
# enabling messages
testctrl = new("RankControlKendall",SearchPi0_show_message=TRUE)
}
\seealso{
\code{\link{RankData}}, \code{\link{RankInit}}, \code{\link{RankControl}}
}

