#' Partition the order generated by a set of intervals
#'
#' A partition of the order generated by a set of intervals is a partition of
#' their indices with the property the sets can be ordered so that the right
#' endpoint of every interval in a set is less than the left endpoint of any
#' interval in any subsequent set.
#'
#' See section 3.2 of Rising (2021).
#'
#' @param intervals data frame (see [rankUncertainty::generateIntervals] for
#' the required format)
#'
#' @return A list whose entries correspond to sets in the partition
#' @export
#'
#' @references
#' Rising, Justin (2021).  _Uncertainty in Ranking_.  arXiv:2107.03459.
#'
#' @examples
#' left <- sort(c(1:3, 1:3 + 0.1))
#' right <- left + 0.7
#' intervals <- data.frame(left = left, right = right)
#' partition(intervals)
partition <- function(intervals)
{
  errorCheck(intervals)

  getPartitionInfo(1:nrow(intervals), intervals[, 'left'], intervals[, 'right'])
}
