% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rangemod_2d.R
\name{rangemod.2d}
\alias{rangemod.2d}
\title{Range cohesion models for spatial polygon grids}
\usage{
rangemod.2d(spmat, shp, field, nb, rsize = c("observed", "unif"), var, reps,
  degen, first)
}
\arguments{
\item{spmat}{a site by species matrix or data frame with species in columns}

\item{shp}{shapefile of sites where species occurences are recorded}

\item{field}{a number or character vector indicating which column in the dbf
of shapefile is the unique id}

\item{nb}{a neighbour object similar to one generated from
\code{\link[spdep]{poly2nb}} of \pkg{\link[spdep]{spdep}}
If 'nb' is NA then result is range scatter}

\item{rsize}{which rangesizes to use for simulation, can be an integer vector
of same length as number of species(collumns)
or either 'observed' or'unif'. See details for explanations}

\item{var}{an optional vector containing explanatory variable for
constraining the randomization}

\item{reps}{number of replicates}

\item{degen}{If true, each randomized site by species matrix is saved and
provided in output}

\item{first}{If true, 'var' is used while choosing the first occurence as
well.if 'var' is null, first is always set 'FALSE'}
}
\value{
A list containing following elements:
\itemize{
 \item{"out.df"}{ a data frame with two columns 'mod.rich' and 'sd.rich'
                   with mean and standard deviation respectively of the
                   predicted species richness }
 \item{"out.shp"}{ same as the input shapefile with the two colums of
                   'out.df' added in attribute table}
 \item{"degenerate.matrices"} {a list of all the randomized matrices(only
                               present if 'degen' is TRUE)}
 }
}
\description{
species richness model for two dimentional grid with geometric
             constraints and range cohesion
}
\details{
rangemod.2d impliments simulations used by Rahbeck et.al. (2007) to
         species distribution data on a continuous grid. In 'spmat' the sites
         (rows) represent each cell in the grid.The species occurences across
         sites are randomly spread maintaining strict range cohesion.
         A neighbour object is used to limit the choice
         of cells during random selctions to immidiate neighbours. Options
         for creating four cell (rook) or eight cell (queen) neighbours can
         be accessed while creating the 'nb' object, (typically from package
         \pkg{\link[spdep]{spdep}}). The randomisation proceeds by selecting a
         single site,(weighted by 'var' if provided, and first is TRUE), and
         then continues selecting one site at a time from a vector of
         available neighbours taken from 'nb' and weighted by 'var' if
         provided. The vector of available sites is updated after each site
         is selected.
}
\examples{
\dontrun{
data(shp)
data(neigh_ob)
data(spmat)
library(ggplot2)
library(plyr)
mod.out <- rangemod.2d(spmat,shp,"NUMMER",nb = neigh_ob,rsize = "observed",
                       var = NULL,reps = 5,degen = F,first = F)
shp.out <- mod.out$out.shp
shp.out$id <- shp.out@data[,"NUMMER"]
shp.out.df <- as.data.frame(shp.out)
shp.out.fort <- fortify(shp.out,region = "id")
shp.out.gg <- join(shp.out.fort,shp.out.df,by = "id")
ggplot(shp.out.gg)+
  geom_map(map=shp.out.gg,aes_string("long","lat",map_id="NUMMER",
                                     fill = "mod.rich"))+
  geom_path(aes(x = long,y = lat,group = group),colour = "white")+
  coord_equal()
}
}
\references{
Rahbek, C., Gotelli, N., Colwell, R., Entsminger, G., Rangel,
             T. & Graves, G. (2007) Predicting continental-scale patterns of
             bird species richness with spatially explicit
             models. Proceedings of the Royal Society B: Biological
             Sciences, 274, 165.

             Gotelli, N.J., Anderson, M.J., Arita, H.T., Chao, A., Colwell,
             R.K., Connolly, S.R., Currie, D.J., Dunn, R.R., Graves, G.R. &
             Green, J.L. (2009) Patterns and causes of species richness:
             a general simulation model for macroecology. Ecology Letters,
             12, 873-886.
}

