% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterByProximity.R
\name{filterByProximity}
\alias{filterByProximity}
\title{Filter by proximity}
\usage{
filterByProximity(xy, dist, returnIndex = FALSE)
}
\arguments{
\item{xy}{longitude and latitude in decimal degrees, either as a matrix,
dataframe, or spatial points object.}

\item{dist}{minimum allowed distance in km}

\item{returnIndex}{if \code{TRUE}, will return indices of points that would
be dropped, if \code{FALSE}, returns the points that satisfy the distance
filter.}
}
\value{
If \code{returnIndex = TRUE}, returns a numeric vector of indices.
If \code{returnIndex = FALSE}, returns coordinates of the same class as the
input.
}
\description{
Filter occurrence records by their proximity to each other.
}
\details{
This function will discard coordinates that fall within a certain distance
from other points.
}
\examples{

data(crotalus)

# within the first 100 points in the dataset, identify the set of points to 
# drop in order to have points no closer to each other than 20 km

subset <- crotalus[1:100,]
tooClose <- filterByProximity(xy= subset[ ,c('decimallongitude','decimallatitude')], 
	dist=20, returnIndex = TRUE)

plot(subset[ ,c('decimallongitude','decimallatitude')], pch=1, col='blue', cex=1.5)
points(subset[tooClose, c('decimallongitude','decimallatitude')], pch=20, col='red')


# testing different input options
samp <- sample(1:nrow(crotalus), 100)
xy <- crotalus[samp, c('decimallongitude', 'decimallatitude')]
sfpts <- sf::st_as_sf(xy, coords = c('decimallongitude', 'decimallatitude'), crs = 4326)
sfptsEA <- sf::st_transform(sfpts, crs = '+proj=eqearth')
spPts <- as(sfpts, 'Spatial')
filterByProximity(xy, dist=20, returnIndex = TRUE)
filterByProximity(sfpts, dist=20, returnIndex = TRUE)
filterByProximity(sfptsEA, dist=20, returnIndex = TRUE)
filterByProximity(spPts, dist=20, returnIndex = TRUE)

}
\author{
Pascal Title
}
