% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolve.R
\name{resolve}
\alias{resolve}
\title{Resolve Dependencies Of R Packages}
\usage{
resolve(
  pkgs,
  snapshot_date,
  no_enhances = TRUE,
  no_suggests = TRUE,
  query_sysreqs = TRUE,
  os = "ubuntu-20.04",
  verbose = FALSE
)
}
\arguments{
\item{pkgs}{character vector of R packages to resolve. \code{pkgs} can be either in shorthands, e.g. "rtoot", "ropensci/readODS", or in package references, e.g. "cran::rtoot", "github::ropensci/readODS". Please refer to the \href{https://r-lib.github.io/pkgdepends/reference/pkg_refs.html}{Package References documentation} of \code{pak} for details. Currently, this package supports only cran and github packages.}

\item{snapshot_date}{Snapshot date, if not specified, assume to be a month ago}

\item{no_enhances}{logical, whether to ignore packages in the "Enhances" field}

\item{no_suggests}{logical, whether to ignore packages in the "Suggests" field}

\item{query_sysreqs}{logical, whether to query for System Requirements. Important: Archived CRAN can't be queried for system requirements. Those
packages are assumed to have no system requirement.}

\item{os}{character, which OS to query for system requirements}

\item{verbose}{logical, whether to display messages}
}
\value{
a \code{rang} S3 object with the following items
\item{call}{original function call}
\item{ranglets}{List of dependency graphs of all packages in \code{pkgs}}
\item{snapshot_date}{\code{snapshot_date}}
\item{no_enhances}{\code{no_enhances}}
\item{no_suggests}{\code{no_suggests}}
\item{unresolved_pkgsrefs}{Packages that can't be resolved}
\item{sysreqs}{System requirements as Linux commands}
\item{r_version}{The latest R version as of \code{snapshot_date}}
\item{os}{\code{os}}
}
\description{
This function recursively queries dependencies of R packages at a specific snapshot time. The dependency graph can then be used to recreate the computational environment. The data on dependencies are provided by R-hub.
}
\examples{
\donttest{
if (interactive()) {
    graph <- resolve(pkgs = c("openNLP", "LDAvis", "topicmodels", "quanteda"),
                snapshot_date = "2020-01-16")
    graph
    ## to resolve github packages
    gh_graph <- resolve(pkgs = c("https://github.com/schochastics/rtoot"),
                   snapshot_date = "2022-11-28")
    gh_graph
}
}
}
\references{
\href{https://r-lib.github.io/pkgdepends/reference/pkg_refs.html}{Package References}
}
\seealso{
\code{\link[=dockerize]{dockerize()}}
}
