% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{plotEv}
\alias{plotEv}
\title{Evaluation plotting}
\usage{
plotEv(evaluation, labels, cols)
}
\arguments{
\item{evaluation}{object of type \code{evaluation}.}

\item{labels}{labels used in the plot. Can be \code{NULL}.}

\item{cols}{colors of the lines representing the  desirability scores in the plot. Can be \code{NULL}.}
}
\value{
A plot of an \code{evaluation} object
}
\description{
Plot of an \code{evaluation} object.
}
\examples{
# compare Random Allocation Rule to Big Stick Design with respect to different issues
# and their corresponding desirability functions
issue1 <- corGuess("CS")
issue2 <- chronBias(type = "linT", theta = 1/4, method = "exact")
RAR <- getAllSeq(rarPar(4))
BSD <- getAllSeq(bsdPar(4, mti = 2))
A1 <- assess(RAR, issue1, issue2, endp = normEndp(c(0,0), c(1,1)))
A2 <- assess(BSD, issue1, issue2, endp = normEndp(c(0,0), c(1,1)))

d1 <- derFunc(TV = 0.5, 0.75, 2)
d2 <- derFunc(0.05, c(0, 0.1), c(1, 1))
DesScore <- getDesScores(A1, d1, d2, weights = c(5/6, 1/6))
DesScore2 <- getDesScores(A2, d1, d2, weights = c(5/6, 1/6))

E <- evaluate(DesScore, DesScore2)
plotEv(E)
}
\seealso{
Other desirability topics: 
\code{\link{derFunc}},
\code{\link{evaluate}()},
\code{\link{getDesScores}()},
\code{\link{plotDes}()},
\code{\link{probUnDes}()}
}
\concept{desirability topics}
