% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combinedBias.R
\name{combineBias}
\alias{combineBias}
\title{Combined bias criterion}
\usage{
combineBias(selBias, chronBias)
}
\arguments{
\item{selBias}{object of class \code{selBias}}

\item{chronBias}{object of class \code{chronBias}}
}
\value{
A combined bias object that combines a \code{selBias} and
a \code{chronBias} object
}
\description{
This class combines a \code{selBias} object and a \code{chronBias} object
to a new object. In the analysis within the new object the
two types of bias are treated as additive effect for normal endpoints
and as multiplicative effect for exponential endpoints.
}
\examples{
chronBias <- chronBias(type="linT", theta=1, method="sim")
selBias <- selBias(type="CS", eta=1, method="sim")
combineBias(selBias, chronBias)
}
\seealso{
Other issues: 
\code{\link{chronBias}},
\code{\link{corGuess}},
\code{\link{imbal}},
\code{\link{issue}},
\code{\link{selBias}},
\code{\link{setPower}()}
}
\concept{issues}
