% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\docType{methods}
\name{compare}
\alias{compare}
\alias{compare,issue,endpoint-method}
\alias{compare,issue,missing-method}
\title{Comparison of randomization procedures}
\usage{
compare(issue, ..., endp)

\S4method{compare}{issue,missing}(issue, ..., endp)

\S4method{compare}{issue,endpoint}(issue, ..., endp)
}
\arguments{
\item{issue}{object of class \code{issue}.}

\item{...}{at least one object of class \code{randSeq} or a list of 
objects of class \code{randSeq}.}

\item{endp}{object of class \code{endpoint}, or \code{missing}.}
}
\value{
\code{S4} object of class \code{comparison} summarizing the comparison of the 
randomization procedures.
}
\description{
Compares randomization procedures based on a specified issue 
in clinical trials.
}
\details{
Randomization procedures behave differently with respect to issues
like selection bias, chronological bias, or loss in power estimation.
The \code{compare} function evaluates the behaviour of randomization 
procedures with respect to one issue. 
Its first argument should represent one of the implemented 
\code{\link{issues}}.
The second argument should be any number of objects of the class
\code{randSeq}. These objects represent the randomization procedures
for the planned comparison. 
The last argument \code{endp} may be provided if 
the assessment should take the distribution of the treamtent groups
into account, e.g. for power evaluation.
}
\examples{
# compare Random Allocation Rule and Big Stick for N = 4
# with respect to the correct guesses
RAR <- getAllSeq(rarPar(4))
BSD <- getAllSeq(bsdPar(4, mti = 2))
corGuess <- corGuess("CS")
(comp <- compare(corGuess, RAR, BSD))
plot(comp)

# compare the same procedures with respect to selection bias
endp <- normEndp(c(2, 2), c(1, 1))
selBias <- selBias("CS", 4, "exact")
(comp <- compare(selBias, RAR, BSD, endp = endp))
plot(comp)

}
\seealso{
Representation of randomization procedures: \code{\link{randPar}}

Generation of randomization sequences: \code{\link{genSeq}}

\code{\link{issues}} for the assessment of randomization sequences
}

