% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_importance.R
\name{plot_multi_way_importance}
\alias{plot_multi_way_importance}
\title{Multi-way importance plot}
\usage{
plot_multi_way_importance(importance_frame, x_measure = "mean_min_depth",
  y_measure = "times_a_root", size_measure = NULL,
  min_no_of_trees = 0, no_of_labels = 10,
  main = "Multi-way importance plot")
}
\arguments{
\item{importance_frame}{A result of using the function measure_importance() to a random forest or a randomForest object}

\item{x_measure}{The measure of importance to be shown on the X axis}

\item{y_measure}{The measure of importance to be shown on the Y axis}

\item{size_measure}{The measure of importance to be shown as size of points (optional)}

\item{min_no_of_trees}{The minimal number of trees in which a variable has to be used for splitting to be used for plotting}

\item{no_of_labels}{The approximate number of best variables (according to all measures plotted) to be labeled (more will be labeled in case of ties)}

\item{main}{A string to be used as title of the plot}
}
\value{
A ggplot object
}
\description{
Plot two or three measures of importance of variables in a random fores. Choose importance measures from the colnames(importance_frame).
}
\examples{
forest <- randomForest::randomForest(Species ~ ., data = iris, localImp = TRUE)
plot_multi_way_importance(measure_importance(forest))

}
