% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rppca.R
\name{rppca}
\alias{rppca}
\alias{rppca.spam}
\alias{rppca.pedigree}
\title{Fast pedigree PCA using sparse matrices and randomised linear algebra}
\usage{
rppca(X, ...)

\method{rppca}{spam}(
  X,
  method = "randSVD",
  rank = 10,
  depth = 3,
  numVectors = 15,
  totVar = NULL,
  center = FALSE,
  ...
)

\method{rppca}{pedigree}(
  X,
  method = "randSVD",
  rank = 10,
  depth = 3,
  numVectors = 15,
  totVar = NULL,
  center = FALSE,
  ...
)
}
\arguments{
\item{X}{A representation of a pedigree, see Details.}

\item{...}{optional arguments passed to methods}

\item{method}{\code{string} only randSVD (the default) is implemented}

\item{rank}{\code{integer} how many principal components to return}

\item{depth}{\code{integer} number of iterations for generating the range matrix}

\item{numVectors}{\code{integer > rank} to specify the oversampling for the
range matrix}

\item{totVar}{\code{scalar} (optional) the total variance, required for
computation of variance proportions when using an L-inverse matrix a input}

\item{center}{\code{logical} whether or not to (implicitly) centre the additive
relationship matrix}
}
\value{
A \code{list} containing:
\describe{
 \item{\code{x}}{the principal components}
 \item{\code{sdev}}{the variance components of each PC. Note that the total variance is
  not known per se and this these components cannot be used to compute the
  proportion of the total variance accounted for by each PC. However, if
  \code{nVecTraceEst} is specified, \code{rppca} will estimate the total variance and
  return variance proportions.}
 \item{\code{vProp}}{the estimated variance proportions accounted for by each PC.
  Only returned if \code{totVar} is set.}
\item{\code{scale}}{always \code{FALSE}}
\item{\code{center}}{\code{logical} indicating whether or not the implicit data matrix was centred}
\item{\code{rotation}}{the right singular values of the relationship matrix.
  Only returned if \code{returnRotation == TRUE}}
\item{\code{varProps}}{proportion of the total variance explained by each PC. Only
  returned if starting from a pedigree object without centring, or if \code{totVar} is supplied.
  }
  }
}
\description{
Fast pedigree PCA using sparse matrices and randomised linear algebra
}
\details{
The output slots are named like those of R's built in \code{prcomp} function.
Rotation is not returned by default as it is the transpose of the PC scores,
which are returned in \code{x}. \code{scale} and \code{center} are set to \code{FALSE}.
}
\examples{
pc <- rppca(pedLInv)
ped <- pedigree(sire=pedMeta$fid,
                dam=pedMeta$mid,
                label=pedMeta$id
                )
pc2 <- rppca(ped)

}
