% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/convenience.R
\name{rand}
\alias{rand}
\title{Matrix/Array of Uniform Random Numbers}
\usage{
rand(nrow = 1, ncol = 1, ..., min = 0, max = 1)
}
\arguments{
\item{nrow}{The desired number of rows.}

\item{ncol}{The desired number of columns.}

\item{...}{Further dimensions of the array.}

\item{min}{Lower limit for the uniform distribution. Must be finite.
(\code{rand} only).}

\item{max}{Upper limit for the uniform distribution. Must be finite.
  (\code{rand} only).}
}
\value{
A  matrix or array of pseudorandom numbers.
}
\description{
Construct a matrix or multi-way array of uniform random deviates.
}
\examples{
rand(100, 100)  # 100 by 100 matrix of uniform random numbers
rand(2, 3, min = 100, max = 200)
}
\seealso{
\code{\link{randi}}, \code{\link{randn}}, \code{\link{runif}}.
}

