/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.utils;

import eu.amidst.core.datastream.Attributes;
import eu.amidst.core.models.DAG;
import eu.amidst.core.variables.Variable;
import eu.amidst.core.variables.Variables;

public class DAGGenerator {
    public static DAG getNaiveBayesStructure(Attributes attributes, String className) {
        Variables modelHeader = new Variables(attributes);
        Variable classVar = modelHeader.getVariableByName(className);
        DAG dag = new DAG(modelHeader);
        dag.getParentSets().stream().filter(w -> w.getMainVar().getVarID() != classVar.getVarID()).forEach(w -> w.addParent(classVar));
        dag.setName("DAGNB");
        return dag;
    }

    public static DAG getHiddenNaiveBayesStructure(Attributes attributes, String varHiddenName, int nstates) {
        Variables modelHeader = new Variables(attributes);
        Variable globalHiddenVar = modelHeader.newMultinomialVariable(varHiddenName, nstates);
        DAG dag = new DAG(modelHeader);
        dag.getParentSets().stream().filter(w -> w.getMainVar() != globalHiddenVar).forEach(w -> w.addParent(globalHiddenVar));
        dag.setName("DAGHiddenNB");
        return dag;
    }
}

