/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.exponentialfamily;

import eu.amidst.core.distribution.ConditionalDistribution;
import eu.amidst.core.distribution.Normal;
import eu.amidst.core.exponentialfamily.EF_ConditionalDistribution;
import eu.amidst.core.exponentialfamily.EF_Normal;
import eu.amidst.core.exponentialfamily.MomentParameters;
import eu.amidst.core.exponentialfamily.NaturalParameters;
import eu.amidst.core.exponentialfamily.SufficientStatistics;
import eu.amidst.core.utils.ArrayVector;
import eu.amidst.core.utils.Vector;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.Variable;
import java.util.ArrayList;
import java.util.Map;

public class EF_NormalGivenJointNormalGamma
extends EF_ConditionalDistribution {
    Variable normalGammaParameterVariable;

    public EF_NormalGivenJointNormalGamma(Variable var_, Variable normalGammaParameterVariable) {
        this.var = var_;
        this.normalGammaParameterVariable = normalGammaParameterVariable;
        this.parents = new ArrayList();
        this.parents.add(normalGammaParameterVariable);
        if (!this.var.isNormal()) {
            throw new UnsupportedOperationException("Creating a Normal-Inverse-Gamma EF distribution for a non-gaussian child variable.");
        }
        if (!this.normalGammaParameterVariable.isNormalGammaParameter()) {
            throw new UnsupportedOperationException("Creating a Normal-Inverse-Gamma EF distribution for a non normal-gamma parent variable.");
        }
    }

    public Variable getNormalGammaParameterVariable() {
        return this.normalGammaParameterVariable;
    }

    @Override
    public double getExpectedLogNormalizer(Map<Variable, MomentParameters> momentParents) {
        double loggamma = momentParents.get(this.normalGammaParameterVariable).get(3);
        double meansquareGamma = momentParents.get(this.normalGammaParameterVariable).get(1);
        return 0.5 * meansquareGamma - 0.5 * loggamma;
    }

    @Override
    public NaturalParameters getExpectedNaturalFromParents(Map<Variable, MomentParameters> momentParents) {
        double muGamma = momentParents.get(this.normalGammaParameterVariable).get(0);
        double gamma = momentParents.get(this.normalGammaParameterVariable).get(2);
        EF_Normal.ArrayVectorParameter naturalParameters = new EF_Normal.ArrayVectorParameter(2);
        naturalParameters.set(0, muGamma / gamma);
        naturalParameters.set(1, gamma);
        return naturalParameters;
    }

    @Override
    public NaturalParameters getExpectedNaturalToParent(Variable parent, Map<Variable, MomentParameters> momentChildCoParents) {
        ArrayVector naturalParameters = new ArrayVector(4);
        double X = momentChildCoParents.get(this.var).get(0);
        double XSquare = momentChildCoParents.get(this.var).get(1);
        naturalParameters.set(0, X);
        naturalParameters.set(1, -0.5);
        naturalParameters.set(2, -0.5 * XSquare);
        naturalParameters.set(3, 0.5);
        return naturalParameters;
    }

    @Override
    public <E extends ConditionalDistribution> E toConditionalDistribution() {
        throw new UnsupportedOperationException("This method does not make sense. Parameter variables can not be converted. Use insteadpublic ConditionalDistribution toConditionalDistribution(Map<Variable, Vector> expectedValueParameterVariables);");
    }

    @Override
    public double getExpectedLogNormalizer(Variable parent, Map<Variable, MomentParameters> momentChildCoParents) {
        throw new UnsupportedOperationException("No Implemented. This method is no really needed");
    }

    @Override
    public void updateNaturalFromMomentParameters() {
        throw new UnsupportedOperationException("No Implemented. NormalInverseGamma distribution should only be used for learning, use EF_Normal for inference.");
    }

    @Override
    public void updateMomentFromNaturalParameters() {
        throw new UnsupportedOperationException("No Implemented. NormalInverseGamma distribution should only be used for learning, use EF_Normal for inference.");
    }

    @Override
    public SufficientStatistics getSufficientStatistics(Assignment data) {
        throw new UnsupportedOperationException("No Implemented. NormalInverseGamma distribution should only be used for learning, use EF_Normal for inference.");
    }

    @Override
    public int sizeOfSufficientStatistics() {
        return 0;
    }

    @Override
    public double computeLogBaseMeasure(Assignment dataInstance) {
        return -0.5 * Math.log(Math.PI * 2);
    }

    @Override
    public double computeLogNormalizer() {
        throw new UnsupportedOperationException("No Implemented. NormalInverseGamma distribution should only be used for learning, use EF_Normal for inference.");
    }

    @Override
    public Vector createZeroVector() {
        throw new UnsupportedOperationException("No Implemented. NormalInverseGamma distribution should only be used for learning, use EF_Normal for inference.");
    }

    @Override
    public ConditionalDistribution toConditionalDistribution(Map<Variable, Vector> expectedValueParameterVariables) {
        Normal normal = new Normal(this.var);
        normal.setMean(expectedValueParameterVariables.get(this.normalGammaParameterVariable).get(0));
        normal.setVariance(1.0 / expectedValueParameterVariables.get(this.normalGammaParameterVariable).get(1));
        return normal;
    }

    @Override
    public SufficientStatistics createInitSufficientStatistics() {
        throw new UnsupportedOperationException();
    }
}

