/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.distribution;

import eu.amidst.core.distribution.ConditionalDistribution;
import eu.amidst.core.distribution.Distribution;
import eu.amidst.core.distribution.Normal;
import eu.amidst.core.distribution.UnivariateDistribution;
import eu.amidst.core.exponentialfamily.EF_Normal_NormalParents;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.Variable;
import java.util.List;
import java.util.Random;

public class ConditionalLinearGaussian
extends ConditionalDistribution {
    private double intercept;
    private double[] coeffParents;
    private double variance;

    public ConditionalLinearGaussian(Variable var1, List<Variable> parents1) {
        this.var = var1;
        this.parents = parents1;
        this.intercept = 0.0;
        this.coeffParents = new double[this.parents.size()];
        for (int i = 0; i < this.parents.size(); ++i) {
            this.coeffParents[i] = 1.0;
        }
        this.variance = 1.0;
    }

    public double getIntercept() {
        return this.intercept;
    }

    public void setIntercept(double intercept1) {
        this.intercept = intercept1;
    }

    public double[] getCoeffParents() {
        return this.coeffParents;
    }

    public void setCoeffParents(double[] coeffParents1) {
        if (coeffParents1.length != this.coeffParents.length) {
            throw new UnsupportedOperationException("The number of beta parametersParentVariables for the Normal_Normal distribution does not match with the number of parents");
        }
        this.coeffParents = coeffParents1;
    }

    public double getCoeffForParent(Variable parentVar) {
        int parentIndex = -1;
        for (int i = 0; i < this.parents.size(); ++i) {
            Variable parent = (Variable)this.parents.get(i);
            if (!parentVar.equals(parent)) continue;
            parentIndex = i;
            break;
        }
        if (parentIndex == -1) {
            throw new UnsupportedOperationException("Variable " + parentVar.getName() + " is not in the list of parents");
        }
        return this.coeffParents[parentIndex];
    }

    public void setCoeffForParent(Variable parentVar, double coeff) {
        int parentIndex = -1;
        for (int i = 0; i < this.parents.size(); ++i) {
            Variable parent = (Variable)this.parents.get(i);
            if (!parentVar.equals(parent)) continue;
            parentIndex = i;
            break;
        }
        if (parentIndex == -1) {
            throw new UnsupportedOperationException("Variable " + parentVar.getName() + " is not in the list of parents");
        }
        this.coeffParents[parentIndex] = coeff;
    }

    public double getSd() {
        return Math.sqrt(this.variance);
    }

    public double getVariance() {
        return this.variance;
    }

    public void setVariance(double variance_) {
        this.variance = variance_;
    }

    public Normal getNormal(Assignment parentsAssignment) {
        double mean = this.intercept;
        Normal univariateNormal = new Normal(this.var);
        int i = 0;
        for (Variable v : this.parents) {
            mean += this.coeffParents[i] * parentsAssignment.getValue(v);
            ++i;
        }
        univariateNormal.setVariance(this.variance);
        univariateNormal.setMean(mean);
        return univariateNormal;
    }

    @Override
    public double[] getParameters() {
        double[] param = new double[this.getNumberOfParameters()];
        param[0] = this.intercept;
        System.arraycopy(this.coeffParents, 0, param, 1, this.coeffParents.length);
        param[param.length - 1] = this.variance;
        return param;
    }

    @Override
    public int getNumberOfParameters() {
        return this.coeffParents.length + 2;
    }

    @Override
    public double getLogConditionalProbability(Assignment assignment) {
        double value = assignment.getValue(this.var);
        return this.getNormal(assignment).getLogProbability(value);
    }

    @Override
    public UnivariateDistribution getUnivariateDistribution(Assignment assignment) {
        return this.getNormal(assignment);
    }

    @Override
    public String label() {
        return "Normal|Normal";
    }

    @Override
    public void randomInitialization(Random random) {
        this.intercept = random.nextGaussian();
        for (int j = 0; j < this.coeffParents.length; ++j) {
            this.coeffParents[j] = random.nextGaussian();
        }
        this.variance = random.nextDouble() + 0.5;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[ alpha = " + this.getIntercept() + ", ");
        for (int i = 0; i < this.getCoeffParents().length; ++i) {
            str.append("beta" + (i + 1) + " = " + this.getCoeffParents()[i] + ", ");
        }
        str.append("var = " + this.getVariance() + " ]");
        return str.toString();
    }

    @Override
    public boolean equalDist(Distribution dist, double threshold) {
        if (dist instanceof ConditionalLinearGaussian) {
            return this.equalDist((ConditionalLinearGaussian)dist, threshold);
        }
        return false;
    }

    public boolean equalDist(ConditionalLinearGaussian dist, double threshold) {
        boolean equals = false;
        if (Math.abs(this.getIntercept() - dist.getIntercept()) <= threshold && Math.abs(this.getSd() - dist.getSd()) <= threshold) {
            equals = true;
            for (int i = 0; i < this.getCoeffParents().length; ++i) {
                equals = equals && Math.abs(this.coeffParents[i] - dist.coeffParents[i]) <= threshold;
            }
        }
        return equals;
    }

    public EF_Normal_NormalParents toEFConditionalDistribution() {
        EF_Normal_NormalParents ef_normal_normalParents = new EF_Normal_NormalParents(this.getVariable(), this.getConditioningVariables());
        ef_normal_normalParents.setBeta0(this.getIntercept());
        ef_normal_normalParents.setBetas(this.coeffParents);
        ef_normal_normalParents.setVariance(this.getVariance());
        return ef_normal_normalParents;
    }
}

