% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliaryFunctions.R
\name{logitAtte}
\alias{logitAtte}
\title{Compute Choice Probabilities and Attention Frequencies for the Logit Attention Rule}
\usage{
logitAtte(mSize = NULL, a = NULL)
}
\arguments{
\item{mSize}{Positive integer, size of the choice problem.}

\item{a}{Numeric, the parameter of the logit attention rule.}
}
\value{
\item{choiceProb}{The vector of choice probabilities.}
\item{atteFreq}{The attention frequency.}
}
\description{
\code{logitAtte} computes choice probabilities and attention frequencies for the logit attention rule
  considered by Brady and Rehbeck (2016). To be specific, for a choice problem \code{S} and its subset \code{T}, the attention that \code{T}
  attracts is assumed to be proportional to its size: \code{|T|^a}, where \code{a} is a parameter that one can specify. It will be assumed that
  the first alternative is the most preferred, and that the last alternative is the least preferred.

  This function is useful for replicating the simulation results in Cattaneo, Ma, Masatlioglu, and Suleymanov (2020),
  and Cattaneo, Cheung, Ma, and Masatlioglu (2021).
}
\examples{
logitAtte(mSize = 5, a = 2)

}
\references{
R. L. Brady and J. Rehbeck (2016). Menu-Dependent Stochastic Feasibility. \emph{Econometrica} 84(3): 1203-1223. \doi{10.3982/ECTA12694}

M. D. Cattaneo, P. Cheung, X. Ma, and Y. Masatlioglu (2021). \href{https://arxiv.org/abs/2110.10650}{Attention Overload}. Working paper.

M. D. Cattaneo, X. Ma, Y. Masatlioglu, and E. Suleymanov (2020). \href{https://arxiv.org/abs/1712.03448}{A Random Attention Model}. \emph{Journal of Political Economy} 128(7): 2796-2836. \doi{10.1086/706861}
}
\author{
Matias D. Cattaneo, Princeton University. \email{cattaneo@princeton.edu}.

Paul Cheung, University of Maryland. \email{hycheung@umd.edu}

Xinwei Ma (maintainer), University of California San Diego. \email{x1ma@ucsd.edu}

Yusufcan Masatlioglu, University of Maryland. \email{yusufcan@umd.edu}

Elchin Suleymanov, Purdue University. \email{esuleyma@purdue.edu}
}
