% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rAtte.R
\name{rAtte}
\alias{rAtte}
\title{rAtte: Estimation and Inference in Random Attention Models}
\usage{
rAtte(menu, choice, pref_list = NULL, nCritSimu = 2000,
  BARatioSELECT = 0.1, BARatioREFINE = 0.1, MNRatioSHRINK = NULL,
  limDataCorr = TRUE)
}
\arguments{
\item{menu}{Numeric matrix of 0s and 1s, the collection of menus.}

\item{choice}{Numeric matrix of 0s and 1s, the collection of choices.}

\item{pref_list}{Numeric matrix, each row corresponds to a preference. For example \code{c(2, 3, 1)} means
2 is preferred to 3 and to 1. When set to \code{NULL}, the default \code{c(1, 2, 3, ...)}
will be used.}

\item{nCritSimu}{Integer, number of simulations for critical value. Default is \code{2000}.}

\item{BARatioSELECT}{Numeric, beta-to-alpha ratio for moment selection method. Default is \code{0.1}.}

\item{BARatioREFINE}{Numeric, beta-to-alpha ratio for refined moment selection method. Default is \code{0.1}.}

\item{MNRatioSHRINK}{Numeric, shrinkage parameter. Default is \code{sqrt(1/log(N))}, where N is the sample size.}

\item{limDataCorr}{Boolean, whether assumes limited data (default is \code{TRUE}). When set to
\code{FALSE}, will assume all menus/choice problems are observed, hence no correction.}
}
\value{
\item{sumStats}{Summary statistics, generated by \code{\link{sumData}}.}
\item{constraints}{Matrices of constraints, generated by \code{\link{genMat}}.}
\item{Tstat}{Test statistic.}
\item{critVal}{Critical values.}
}
\description{
Given a random sample with menu information and choices, \code{rAtte}
  returns test statistics and critical values against a specific preference.
  Five methods for choosing critical values are available: (i) \code{PI}: critical values
  based on plug-in (estimated) moment inequalities (this is not uniformly valid);
  (ii) \code{LF}: least favorable critical values; (iii) \code{MS}: moment selection;
  (iv) \code{UB}: refined moment selection (plug-in upper bound of moment inequalities);
  and (v) \code{S}: plug-in (estimated) moment inequalities with shrinkage (this is the
  recommended procedure).

\code{\link{sumData}} is a low-level function that generates summary statistics, and
  \code{\link{genMat}} can be used to construct the constraint matrices. The simulated dataset
  \code{\link{ramdata}} is also provided for illustration.
}
\examples{
# load data
data(ramdata)

# seed, to replicate simulated critical values
set.seed(42)

result <- rAtte(menu = menu, choice = choice,
  pref_list=matrix(c(1, 2, 3, 4, 5, 6,
                     2, 3, 4, 5, 6, 1,
                     3, 4, 5, 6, 2, 1,
                     4, 5, 6, 3, 2, 1,
                     6, 5, 4, 3, 2, 1), ncol=6, byrow=TRUE))
summary(result)

}
\references{
M. D. Cattaneo, X. Ma, Y. Masatlioglu and E. Suleymanov (2017). \href{http://www-personal.umich.edu/~cattaneo/papers/Cattaneo-Ma-Masatlioglu-Suleymanov_2017_RAM.pdf}{A Random Attention Model}. Working Paper, University of Michigan.
}
\author{
Matias D. Cattaneo, University of Michigan. \email{cattaneo@umich.edu}.

Xinwei Ma (maintainer), University of Michigan. \email{xinweima@umich.edu}

Yusufcan Masatlioglu, University of Maryland. \email{yusufcan@umd.edu}

Elchin Suleymanov, University of Michigan. \email{elchin@umich.edu}
}
