% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{implied_volatility}
\alias{implied_volatility}
\title{Implied volatility of european-exercise option under Black-Scholes or a jump-process extension}
\usage{
implied_volatility(option_price, callput, S0, K, r, time,
  const_default_intensity = 0, divrate = 0, borrow_cost = 0,
  dividends = NULL, relative_tolerance = 1e-06, max.iter = 100,
  max_vola = 4)
}
\arguments{
\item{option_price}{Present option value}

\item{callput}{1 for calls, -1 for puts}

\item{S0}{initial underlying price}

\item{K}{strike}

\item{r}{risk-free interest rate}

\item{time}{Time from \code{0} until expiration}

\item{const_default_intensity}{hazard rate of underlying default}

\item{divrate}{A continuous rate for dividends and other cashflows such as foreign interest rates}

\item{borrow_cost}{A continuous rate for stock borrow costs}

\item{dividends}{A \code{data.frame} with columns \code{time}, \code{fixed},
and \code{proportional}.  Dividend size at the given \code{time} is
then expected to be equal to \code{fixed + proportional * S / S0}.  Fixed
dividends will be converted to proportional for purposes of this algorithm.  To handle
truly fixed dividends, see \code{\link{implied_jump_process_volatility}}}

\item{relative_tolerance}{Relative tolerance in option price to achieve before halting the search}

\item{max.iter}{Number of iterations to try before abandoning the search}

\item{max_vola}{Maximum volatility to try in the search}
}
\value{
A scalar volatility
}
\description{
Find default-free volatility (not necessarily just Black-Scholes) based on
 known interest rates and hazard rates, using a given option price.
}
\details{
To get a straight Black-Scholes implied volatility, simply call this function with
 \code{const_default_intensity} set to zero (the default).
}
\examples{
implied_volatility(2.5, 1, 100, 105, 0.01, 0.75)
implied_volatility(option_price = 17,
                   callput = CALL, S0 = 250,  K=245,
                   r = 0.005, time = 2,
                   const_default_intensity = 0.03)
}
\seealso{
Other Equity Independent Default Intensity: \code{\link{american_implied_volatility}},
  \code{\link{american}},
  \code{\link{black_scholes_on_term_structures}},
  \code{\link{blackscholes}},
  \code{\link{equivalent_bs_vola_to_jump}},
  \code{\link{equivalent_jump_vola_to_bs}},
  \code{\link{implied_volatilities_with_rates_struct}},
  \code{\link{implied_volatilities}},
  \code{\link{implied_volatility_with_term_struct}}

Other European Options: \code{\link{black_scholes_on_term_structures}},
  \code{\link{blackscholes}},
  \code{\link{implied_volatilities_with_rates_struct}},
  \code{\link{implied_volatilities}},
  \code{\link{implied_volatility_with_term_struct}}

Other Implied Volatilities: \code{\link{american_implied_volatility}},
  \code{\link{equivalent_bs_vola_to_jump}},
  \code{\link{equivalent_jump_vola_to_bs}},
  \code{\link{fit_variance_cumulation}},
  \code{\link{implied_jump_process_volatility}},
  \code{\link{implied_volatilities_with_rates_struct}},
  \code{\link{implied_volatilities}},
  \code{\link{implied_volatility_with_term_struct}}
}
\keyword{Black-Scholes}

