% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/cross_tabs.R
\name{plot.cross_tabs}
\alias{plot.cross_tabs}
\title{Plot method for the cross_tabs function}
\usage{
\method{plot}{cross_tabs}(x, ct_check = "", ...)
}
\arguments{
\item{x}{Return value from \code{\link{cross_tabs}}}

\item{ct_check}{Show plots for variables ct_var1 and ct_var2. "observed" for the observed frequencies table, "expected" for the expected frequencies table (i.e., frequencies that would be expected if the null hypothesis holds), "chi_sq" for the contribution to the overall chi-squared statistic for each cell (i.e., (o - e)^2 / e), "dev_std" for the standardized differences between the observed and expected frequencies (i.e., (o - e) / sqrt(e)), and "dev_perc" for the percentage difference between the observed and expected frequencies (i.e., (o - e) / e)}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the cross_tabs function
}
\details{
See \url{http://vnijs.github.io/radiant/quant/cross_tabs.html} for an example in Radiant
}
\examples{
result <- cross_tabs("newspaper", "Income", "Newspaper")
plot(result, ct_check = c("observed","expected","chi_sq"))
}
\seealso{
\code{\link{cross_tabs}} to calculate results

\code{\link{summary.cross_tabs}} to summarize results
}

