% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/radiant.R
\name{getdata}
\alias{getdata}
\title{Get data for analysis functions}
\usage{
getdata(dataset, vars = "", na.rm = TRUE, filt = "", slice = "")
}
\arguments{
\item{dataset}{Name of the dataframe}

\item{vars}{Variables to extract from the dataframe}

\item{na.rm}{Remove rows with missing values (default is TRUE)}

\item{filt}{Filter to apply to the specified dataset. For example "price > 10000" if dataset is "diamonds" (default is "")}

\item{slice}{Select a slice of the specified dataset. For example "1:10" for the first 10 rows or "n()-10:n()" for the last 10 rows (default is ""). Not in Radiant GUI}
}
\value{
Data.frame with specified columns and rows
}
\description{
Get data for analysis functions
}
\examples{
r_data <- list()
r_data$dat <- mtcars
getdata("dat","mpg:vs", filt = "mpg > 20", slice = "1:5")
}

