% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalbin.R
\name{confusion}
\alias{confusion}
\title{Confusion matrix}
\usage{
confusion(
  dataset,
  pred,
  rvar,
  lev = "",
  cost = 1,
  margin = 2,
  train = "All",
  data_filter = "",
  envir = parent.frame(),
  ...
)
}
\arguments{
\item{dataset}{Dataset}

\item{pred}{Predictions or predictors}

\item{rvar}{Response variable}

\item{lev}{The level in the response variable defined as success}

\item{cost}{Cost for each connection (e.g., email or mailing)}

\item{margin}{Margin on each customer purchase}

\item{train}{Use data from training ("Training"), test ("Test"), both ("Both"), or all data ("All") to evaluate model evalbin}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{envir}{Environment to extract data from}

\item{...}{further arguments passed to or from other methods}
}
\value{
A list of results
}
\description{
Confusion matrix
}
\details{
Confusion matrix and additional metrics to evaluate binary classification models. See \url{https://radiant-rstats.github.io/docs/model/evalbin.html} for an example in Radiant
}
\examples{
data.frame(buy = dvd$buy, pred1 = runif(20000), pred2 = ifelse(dvd$buy == "yes", 1, 0)) \%>\%
  confusion(c("pred1", "pred2"), "buy") \%>\%
  str()
}
\seealso{
\code{\link{summary.confusion}} to summarize results

\code{\link{plot.confusion}} to plot results
}
