% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulater.R
\name{plot.simulater}
\alias{plot.simulater}
\title{Plot method for the simulater function}
\usage{
\method{plot}{simulater}(x, shiny = FALSE, custom = FALSE, ...)
}
\arguments{
\item{x}{Return value from \code{\link{simulater}}}

\item{shiny}{Did the function call originate inside a shiny app}

\item{custom}{Logical (TRUE, FALSE) to indicate if ggplot object (or list of ggplot objects) should be returned. This opion can be used to customize plots (e.g., add a title, change x and y labels, etc.). See examples and \url{http://docs.ggplot2.org/} for options.}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the simulater function
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/simulater} for an example in Radiant
}
\examples{
result <- simulater(const = "cost 3", norm = "demand 2000 1000",
                    discrete = "price 5 8 .3 .7",
                    form = "profit = demand * (price - cost)")
plot(result)

}
\seealso{
\code{\link{simulater}} to generate the result

\code{\link{summary.simulater}} to summarize results
}
