% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic.R
\name{logistic}
\alias{logistic}
\title{Logistic regression}
\usage{
logistic(dataset, rvar, evar, lev = "", int = "", wts = "None",
  check = "", data_filter = "")
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{rvar}{The response variable in the model}

\item{evar}{Explanatory variables in the model}

\item{lev}{The level in the response variable defined as _success_}

\item{int}{Interaction term to include in the model}

\item{wts}{Weights to use in estimation}

\item{check}{Use "standardize" to see standardized coefficient estimates. Use "stepwise-backward" (or "stepwise-forward", or "stepwise-both") to apply step-wise selection of variables in estimation}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}
}
\value{
A list with all variables defined in logistic as an object of class logistic
}
\description{
Logistic regression
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/logistic.html} for an example in Radiant
}
\examples{
result <- logistic("titanic", "survived", c("pclass","sex"), lev = "Yes")
result <- logistic("titanic", "survived", c("pclass","sex"))

}
\seealso{
\code{\link{summary.logistic}} to summarize the results

\code{\link{plot.logistic}} to plot the results

\code{\link{predict.logistic}} to generate predictions

\code{\link{plot.model.predict}} to plot prediction output
}
