% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_size.R
\name{sample_size}
\alias{sample_size}
\title{Sample size calculation}
\usage{
sample_size(
  type,
  err_mean = 2,
  sd_mean = 10,
  err_prop = 0.1,
  p_prop = 0.5,
  conf_lev = 0.95,
  incidence = 1,
  response = 1,
  pop_correction = "no",
  pop_size = 1e+06
)
}
\arguments{
\item{type}{Choose "mean" or "proportion"}

\item{err_mean}{Acceptable Error for Mean}

\item{sd_mean}{Standard deviation for Mean}

\item{err_prop}{Acceptable Error for Proportion}

\item{p_prop}{Initial proportion estimate for Proportion}

\item{conf_lev}{Confidence level}

\item{incidence}{Incidence rate (i.e., fraction of valid respondents)}

\item{response}{Response rate}

\item{pop_correction}{Apply correction for population size ("yes","no")}

\item{pop_size}{Population size}
}
\value{
A list of variables defined in sample_size as an object of class sample_size
}
\description{
Sample size calculation
}
\details{
See \url{https://radiant-rstats.github.io/docs/design/sample_size.html} for an example in Radiant
}
\examples{
sample_size(type = "mean", err_mean = 2, sd_mean = 10)

}
\seealso{
\code{\link{summary.sample_size}} to summarize results
}
