> Create a (reproducible) report

The best way to store your work in Radiant is use to use the _R > Report_ feature and save a state-file with all your results and settings. The report feature in Radiant should be used in conjunction with the <i title='Report results' class='fa fa-edit'></i> icons shown on the bottom of the (left) side bar on all analysis pages.

The editor shown on the left in _R > Report_ shows past commands in **R-code chunks**. These _chunks_ can include R-code you typed or code generated by Radiant and added to the report after clicking an <i title='Report results' class='fa fa-edit'></i> icon. All code blocks start with ```` ```{r} ```` and are closed by ```` ``` ````

By default Radiant will add the code generated for the analysis you just completed to the bottom of the report. After clicking a <i title='Report results' class='fa fa-edit'></i> icon Radiant will, by default, switch to the _R > Report_ tab. Click inside the editor window on the left and scroll down to see the generated commands. However, you can choose to select `Manual paste` instead or `Auto paste` from the appropriate drop-down in the _R > Report_ tab. With `Manual paste` the code is put into the clipboard when you click <i title='Report results' class='fa fa-edit'></i> and you can paste it where you want in the editor window.

You can also choose not to switch tabs after clicking  a <i title='Report results' class='fa fa-edit'></i> icon by selecting `Don't switch tab` from the appropriate drop-down in the _R > Report_ tab.

If you started Radiant from Rstudio, you can even choose to have commands sent to an R-code or Rmarkdown document open in Rstudio by selecting `To R` or `To Rmd` respectively instead of `Auto paste` or `Manual paste`.

You can add text or additional commands to create an Rmarkdown document. An Rmarkdown file (extension .Rmd) is a plain text file that can be opened in Notepad (Windows), TextEdit (Mac), Rstudio, Sublime Text, or any other text editor. Please do **not** use Word to edit rmarkdown files.

Using Rmarkdown is extremely convenient because you can replicate your entire analysis very quickly without having to generate or type all commands again.

By clicking the `Knit report` button on the top-left of your screen, the output from the analysis will be (re)created on the right of the _R > Report_ page. You can add text, bullets, headers, etc. around the code chunks to describe and explain the results using <a href="http://rmarkdown.rstudio.com/authoring_pandoc_markdown.html" target="_blank">markdown</a>. To evaluate only a part of the report use the cursor to select a section and press CTRL-return (CMD-return on mac) to create the (partial) output.

If you started Radiant from Rstudio you can save the report in various formats (i.e., HTML, Word, or PDF). To save the Rmarkdown file open in the editor select `Rmd` (or `Rmd & Data`) and press `Save report`. Note that Windows users will need to  install <a href="https://cran.r-project.org/bin/windows/Rtools/Rtools33.exe" target="_blank">Rtools</a> for the `Rmd & Data` feature to work.

The best way to save your analyses and settings is to save the `state` of the application to a file by clicking on the <i title='Save' class='fa fa-save'></i> icon in the navbar and then clicking on `Save state`. The state-file (extension rda) will contain (1) the data loaded in Radiant, (2) settings for the analyses you were working on, (3) and any reports or code from the R-menu. Save the state-file to your hard-disk and, when you are ready to continue, simply load it by selecting `state` from the `Load data of type` dropdown in the <a href="/docs/data/manage.html" target="_blank">_Data > Manage_</a> tab and clicking the `Choose file` button.

If you are using Radiant for a class I suggest you use the _R > Report_ feature to complete assignments and cases. When you are done, generate an HTML (or Word or PDF) report by clicking the `Save report` button. Submit both the report and your state-file.
