% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphic_functions.R
\name{plotDeletionsByBinom}
\alias{plotDeletionsByBinom}
\title{Graphical output of double chromosome deletions}
\usage{
plotDeletionsByBinom(
  GENE.usage.df,
  genes.low.cer = c("IGHV3-43", "IGHV3-20"),
  genes.dup = c("IGHD4-11", "IGHD5-18")
)
}
\arguments{
\item{GENE.usage.df}{double chromosome deletion summary table. See details.}

\item{genes.low.cer}{a vector of IGH genes known to be with low certantiny in the binomial test. Default is IGHV3-43 and IGHV3-20}

\item{genes.dup}{a vector of IGH genes known to have a duplicated gene. Default is IGHD4-11 that his duplicate is IGHD4-4 and IGHD5-18 that his duplicate is IGHD5-5}
}
\value{
A double chromosome deletion visualization.
}
\description{
The \code{plotDeletionsByBinom} function generates a graphical output of the double chromosome deletions in multiple samples.
}
\details{
A \code{data.frame} created by \code{binom_test_deletion}.
}
\examples{

# Load example data and germlines
data(samples_db)

# Infering haplotype
deletions_db = deletionsByBinom(samples_db);
plotDeletionsByBinom(deletions_db)

}
