% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{df_county_unemployment}
\alias{df_county_unemployment}
\title{A data.frame Containing US County Unemployment Rates}
\usage{
data(df_county_unemployment)
}
\description{
Contains annualized data from 1990-2013. Data comes from the US Bureau
of Labor Statistics (BLS) Local Area Unemployment Statistics (LAUS) webpage: http://www.bls.gov/lau/.
The "region" column contains the numeric version of the County FIPS Code.
}
\examples{

data(df_county_unemployment)

head(df_county_unemployment)
boxplot(df_county_unemployment[, c(-1, -2, -3)],
        main="USA County Unemployment Data",
        xlab="Year", 
        ylab="Percent Unemployment")
        
\dontrun{
county_unemployment_choropleth(year=2013)
}
}
\author{
Ari Lamstein
}
\references{
Created via build_county_df() on January 4, 2015.
}
\keyword{data}

